//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef _ELEMENT_ASSOCIATION_HH
#define _ELEMENT_ASSOCIATION_HH

#include "ArrayInfo.hh"
#include "VHDLType.hh"
class ElementAssociation {
public:
  ArrayInfo choice;
  VHDLType* value;
  ElementAssociation(): choice(Others), value(NULL) {
  }

  ElementAssociation(ArrayInfo a, VHDLType* v): choice(a), value(v) {
  }

  ElementAssociation(int index, VHDLType* v): 
    choice(index, to, index),
    value(v) {
  }
  ElementAssociation(int index, VHDLType &v):
    choice(index, to, index),
    value(&v){
  }

  ElementAssociation(UniversalInteger index, VHDLType* v): 
                     choice(index.val, to, index.val),
		     value(v) {
  }
};

#endif //ifndef _ELEMENT_ASSOCIATION_HH
