/*$Id: d_vs.h,v 15.11 1999/10/14 07:46:49 al Exp $ -*- C++ -*-
 * fixed voltage source
 */
#ifndef D_VS_H
#define D_VS_H
#include "e_elemnt.h"
/*--------------------------------------------------------------------------*/
class DEV_VS : public ELEMENT {
private:
  explicit DEV_VS(const DEV_VS& p) :ELEMENT(p) {}
public:
  explicit DEV_VS()		:ELEMENT() {}
private: // override virtual
  const char* dev_type()const	{return "vsource";}
  bool	   is_source()const	{return true;}
  CARD*	   clone()const		{return new DEV_VS(*this);}
  //void   parse(CS&);		//ELEMENT
  //void   print(OMSTREAM,int)const; //ELEMENT
  //void   expand();		//CARD/nothing
  void	   precalc();

  void	   dc_begin();
  void	   tr_begin()		{dc_begin();}
  void	   tr_restore()		{dc_begin();}
  //void   dc_advance();	//CARD/nothing
  //void   tr_advance();	//CARD/nothing
  //bool   tr_needs_eval();	//ELEMENT
  //void   tr_queue_eval();	//ELEMENT
  bool	   do_tr();
  void	   tr_load()		{tr_load_loss(); tr_load_source();}
  //double tr_review();		//CARD/nothing
  //void   tr_accept();		//CARD/nothing
  void	   tr_unload()		{tr_unload_source();}
  double   tr_involts()const	{return 0;}

  void	   ac_begin()		{loss = 1./OPT::shortckt; acg = ev = 0.;}
  void	   do_ac();
  COMPLEX  ac_involts()const	{return 1.;}
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
