/*$Id: d_ccvs.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * functions for ccvs
 * It is really voltage controlled, taking into account the sense element.
 * Then adjust the gain to account for the sense element.
 */
#include "d_ccvs.h"
/*--------------------------------------------------------------------------*/
void DEV_CCVS::precalc()
{
  loss = 1./OPT::shortckt;
  y0.f0 = LINEAR;
  y0.f1 = value();
  m0.c1 = -loss * value();
  m0.c0 = 0.;
  set_converged();
  assert(!constant()); /* because of incomplete analysis */
}
/*--------------------------------------------------------------------------*/
void DEV_CCVS::dc_begin()
{
  loss = 1./OPT::shortckt;
  if (!has_tr_eval()){
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value());
  }
}
/*--------------------------------------------------------------------------*/
bool DEV_CCVS::do_tr()
{
  assert(_input);
  {if (has_tr_eval()){
    m0.x = volts_limited(n[IN1], n[IN2]);
    y0.x = _input->tr_amps();
    tr_eval();
    m0.c0 = y0.f0 - y0.x * y0.f1;
  }else{
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value());
    m0.c0 = 0.;
    assert(converged());
  }}
  m0.c0 += y0.f1 * _input->m0.c0;
  m0.c1  = y0.f1 * (_input->loss + _input->m0.c1);
  m0 *= -loss;
  store_values();
  q_load();
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_CCVS::do_ac()
{
  assert(_input);
  if (!_input->evaluated()){
    untested();
    _input->do_ac();	    /* BUG: premature load of sense element */
  }
  ac_load_loss();
  {if (has_ac_eval()){
    untested();
    ac_eval();
  }else{
    assert(ev == y0.f1);
    assert(has_tr_eval() || ev == value());
  }}
  {if (_input->is_source()){
    acg = -loss * ev * _input->acg;
    ac_load_source();
    acg = -loss * ev * _input->loss;
  }else{
    acg = -loss * ev * _input->acg;
  }}
  ac_load_active();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
