#ifndef __RTL_SYNC__
#define __RTL_SYNC__

#include <asm/rtl_sync.h>


#define rtl_spin_lock_irqsave(x, flags) \
	do { rtl_no_interrupts(flags); rtl_spin_lock(x); } while (0)
#define rtl_spin_unlock_irqrestore(x, flags) \
	do { rtl_spin_unlock(x); rtl_restore_interrupts(flags); } while (0)


#define rtl_critical(f) {rtl_spin_lock_irqsave(&RTL_SPIN_LOCK, f);}
#define rtl_end_critical(f) {rtl_spin_unlock_irqrestore(&RTL_SPIN_LOCK, f);}


#endif

