#include "kvmem.h"

/* allocate user space mmapable block of memory in the kernel space */
void * rvmalloc(unsigned long size)
{
	void * mem;
	unsigned long adr, page;
        
	mem=vmalloc(size);
	if (mem) 
	{
		memset(mem, 0, size); /* Clear the ram out, no junk to the user */
	        adr=(unsigned long) mem;
		while (size > 0) 
                {
	                page = kvirt_to_phys(adr);
			mem_map_reserve(MAP_NR(phys_to_virt(page)));
			adr+=PAGE_SIZE;
			size-=PAGE_SIZE;
		}
	}
	return mem;
}

void rvfree(void * mem, unsigned long size)
{
        unsigned long adr, page;
        
	if (mem) 
	{
	        adr=(unsigned long) mem;
		while (size > 0) 
                {
	                page = kvirt_to_phys(adr);
			mem_map_unreserve(MAP_NR(phys_to_virt(page)));
			adr+=PAGE_SIZE;
			size-=PAGE_SIZE;
		}
		vfree(mem);
	}
}

/* this function will map (fragment of) rvmalloc'ed memory area to user space */
int rvmmap(void *mem, unsigned memsize, struct vm_area_struct *vma) {
	unsigned long pos, size, start=vma->vm_start;
	/* this is not time critical code, so we check the arguments */
	/* vma->vm_offset HAS to be checked (and is checked)*/
	if (vma->vm_offset<0)
		return -EFAULT;
	size = vma->vm_end - vma->vm_start;
	if (size + vma->vm_offset > memsize)
		return -EFAULT;
	pos = (unsigned long) mem + vma->vm_offset;
	if (pos%PAGE_SIZE || start%PAGE_SIZE || size%PAGE_SIZE)
		return -EFAULT;
		
	while (size>0) {
		if (remap_page_range(start,kvirt_to_phys(pos), PAGE_SIZE, 
			vma->vm_page_prot )) {
			/* FIXME: what should we do here to unmap previous pages ?*/
			printk(KERN_ERR "rvmmap failed: vm_start=0x%lx, vm_end=0x%lx, size=0x%lx, pos=0x%lx; please report to motyl@stan.chemie.unibas.ch\n",vma->vm_start,vma->vm_end,size,pos);
			return -EFAULT;
		}
		pos+=PAGE_SIZE;
		start+=PAGE_SIZE;
		size-=PAGE_SIZE;
	}
	return 0;
}
