/****************************************************************************
**
** getuserinfo.c
**
** Michael S. Borella 
**
** Get the calling user's email address and gecos information and pass it
** back in a string in the following format:
**
** mborella@stratos (Mike Borella)
**
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include "getuserinfo.h"
#include "error.h"

#define HOST_SIZE 80
#define NAME_SIZE 256

/*---------------------------------------------------------------------------
 * 
 * getuserinfo()
 *
 * Standard way of getting a userid and gecos info
 * 
 *-------------------------------------------------------------------------*/

char *getuserinfo(void)
{
  int uid;
  struct passwd *pw;
  static char namestr[NAME_SIZE];
  char *ptr;
  char *userid;
  char *gecos;
  char host[HOST_SIZE];

  /*
   * First get the userid and gecos info
   */

  uid = getuid();
  pw = getpwuid(uid);
  if (pw == NULL) 
    return NULL;
  userid = pw->pw_name;
  gecos = pw->pw_gecos;

  /*
   * If gecos includes those annoying ,,, then get rid of them
   */

  ptr = strchr(gecos, ',');
  if (ptr) 
    *ptr = '\0';

  /*
   * Now get the domain name
   */

  if (gethostname(host, HOST_SIZE) < 0)
    syserr("can't get host name");

  /*
   * Put it all together
   */

  memset(namestr, '\0', NAME_SIZE);
  strncpy(namestr, userid, strlen(userid));
  strncat(namestr, "@", 1);
  strncat(namestr, host, strlen(host));
  strncat(namestr, " (", 2);
  strncat(namestr, gecos, strlen(gecos));
  strncat(namestr, ")", 1);

  return namestr;
}






