/**************************************************************************** 
** File: error.c
**
** Author: Mike Borella
**
** Comments: Try to gracefully handle errors.
**
*****************************************************************************/

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include "error.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/*
 * This avoids a warning with glibc compilation 
 */

#ifndef errno
extern int errno;
#endif

/*----------------------------------------------------------------------------
**
** Function: my_strerror()
**
** Comments: Use strerror() if this system supports it. Roll our own otherwise.
**
*/

char *my_strerror(int errnum)
{
#ifdef HAVE_STRERROR
        return (strerror(errnum));
#else
        extern int sys_nerr;
        static char ebuf[20];

        if ((int) errnum < sys_nerr)
                return ((char *) sys_errlist[errnum]);
        (void) sprintf(ebuf, "Unknown error: %d", errnum);
        return(ebuf);
#endif
}


/*----------------------------------------------------------------------------
**
** syserr()
**
** Use only when a system call fails.  Not for general errors.
**
**----------------------------------------------------------------------------
*/

void syserr(char *fmt, ...)
{
  
  va_list       args;
  char          *my_strerror(int);

  va_start(args,fmt);
  
  fprintf(stderr,"ERROR: ");
  vfprintf(stderr, fmt, args);
  fprintf(stderr," (%d ", errno);
  va_end(args);

  fprintf(stderr, "%s)\n", my_strerror(errno));

  exit(1);

}


/*----------------------------------------------------------------------------
**
** ftlerr()
**
** General fatal error.
**
**----------------------------------------------------------------------------
*/

void ftlerr(char *fmt, ...)
{
  
  va_list       args;

  va_start(args,fmt);
  
  fprintf(stderr,"ERROR: ");
  vfprintf(stderr, fmt, args);
  va_end(args);

  fprintf(stderr, "\n");

  exit(1);

}

