/*
  doc.h

  Copyright (c) 1996 Roland Wunderling, Malte Zoeckler
  Copyright (c) 1998 Michael Meeks
  Copyright (c) 1999 Dragos Acostachioaie

  This file is part of DOC++.

  DOC++ is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public
  License as published by the Free Software Foundation; either
  version 2 of the license, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _DOC_H
#define _DOC_H

#include <stdio.h>

#include "McDArray.h"
#include "McHashTable.h"
#include "McString.h"
#include "config.h"

#define DOCXX_VERSION	"3.3.15"

#define MAX_TEX_PACKAGES 10

#ifdef WIN32
#define PATH_DELIMITER '\\'
#else
#define PATH_DELIMITER '/'
#define stricmp strcasecmp
#endif

extern FILE	*out;

extern int	setContext (int);

extern bool	onlyDocs;			// --all
extern bool	commentExtn;			// --c-comments
extern bool	HTMLsyntax;			// --html
extern bool	java;				// --java
extern bool	noDefines;			// --no-define
extern bool	withPrivate;			// --private
extern bool	QuantelExtn;			// --quantel
extern bool	upArrows;			// --upwards-arrows
extern bool	verb;				// --verbose

extern bool	showFilenames;			// --filenames
extern bool	showFilePath;			// --filenames-path
extern bool	showInherited;			// --no-inherited
extern bool	alwaysPrintDocSection;		// --no-members
extern bool	showMembersInTOC;		// --full-toc

//{{{ Commented with a Quantel folding extension
enum _SectionType
{
    EMPTY_SEC		= 1,
    MANUAL_SEC		= 2,
    VARIABLE_SEC	= 4,
    FUNCTION_SEC	= 8,
    MACRO_SEC		= 16,
    CLASS_SEC		= 32,
    UNION_SEC		= 64,
    INTERFACE_SEC	= 128,
    PACKAGE_SEC		= 256,
    TYPEDEF_SEC		= 512,
    NAMESPACE_SEC	= 1024,
    ALL_SEC		= 0x0fff
} ;
//}}}

enum PROTECTION
{
    PUBL='l',
    PROT='t',
    PRIV='v'
} ;

enum LANGUAGE
{
    LANG_UNKNOWN = '?',
    LANG_JAVA    = 'j',
    LANG_CXX     = 'c'
};

/** An entry in the documentation database.

    This class is the primary data item created when scanning source. Each
    documented item, whether a class, function, or other item, is given its
    own object
*/
class Entry
{
 public:
    /// Constructor
    Entry();

    /** Adds `name' to the list of base classes and to the list of `name''s
	subclasses.
    */
    void addBaseClass(const char *name, PROTECTION state);

    void addBaseClass(Entry *name, PROTECTION state);

    void addSubEntry(Entry *e);

    void dumpNumber(FILE *);

    void dumpNumber(McString &);

    /// Dump all class data
    void dump(FILE *, int recursive = 0);

    void findBases();

    Entry *findSub(const char *);
    Entry *findSub(const char *name, int von, int bis);

    void getPackage(McString &);

    /// Is this a class or an interface?
    int isClass();

    /** Creates a fully qualified name with respect to the
        current import and package statements
    */
    void makeFullName(McString &name);

    void makeFullName();

    /// Creates the base classes arrays
    void makeRefs();

    void makeSubList();

    Entry *newSubEntry();

    void removeSub(Entry *);

    static void setupLangHash();

    /// Language (C/C++ or Java)
    char language;

    /// Entry type (class, function, etc.)
    unsigned short section;

    /// True if this entry can be tied to a class
    bool general;

    /// Access right (pulic, protected or private)
    char protection;

    /// True if this entry will get it's own HTML page
    bool ownPage;

    /// The parent of this entry
    Entry *parent;

    /// The next entry at this level
    Entry *next;

    /// Linked list of sub-entries at this level
    Entry *sub;

    /// Return type of the entry
    McString type;

    /// Name of the entry
    McString name;

    /// Full name of the entry (includes the inheritance)
    McString fullName;

    /// Arguments for the entry
    McString args;

    /// Memo section documentation
    McString memo;

    /// Main documentation
    McString doc;

    McString program;

    /// Author info
    McString author;

    /// Version info
    McString version;

    /// Array of "see also" notations
    McDArray<McString *> see;

    /// Array of parameters documentation
    McDArray<McString *> param;

    /// Array of thrown exceptions
    McDArray<McString *> exception;

    /// Return value documentation
    McString retrn;

    /// Array of sub-entries to this one
    McDArray<Entry *> sublist;

    McDArray<Entry*>	pubChilds;
    McDArray<Entry*>	proChilds;
    McDArray<Entry*>	priChilds;
    McDArray<Entry*>	baseclasses;		// to be removed !!!
    McDArray<Entry*>	pubBaseclasses;
    McDArray<Entry*>	proBaseclasses;
    McDArray<Entry*>	priBaseclasses;

    /// base classes that are not documented
    McDArray<McString*>	otherPubBaseclasses ;
    McDArray<McString*>	otherProBaseclasses ;
    McDArray<McString*>	otherPriBaseclasses ;
    McDArray<McString*>	implements ;
    McDArray<McString*>	extends ;
    McDArray<McString*>	import ;
    Entry*		currentParent ;		// for temporary use in TeX output

    /** If this member overrides something from a baseclass, this points to
        the overridden member.
    */
    Entry *override;

    McString	fileName;
    int		startLine ;

    // These are the html-ified  strings
    char	*htype ;
    char	*hname ;
    char	*hargs ;
    char	*hmemo ;
    char	*hsee ;
    char	*hdoc ;

    McString	file ;
    int		line ;
    int		tex ;
    int		number ;
    int		subnumber ;

    int		fromUnknownPackage;
};

struct namespace_entry {
    char *name;
    int innerCurlyCount;
};

extern Entry*	root ;
extern void	printYYDOC( Entry*, const char* str, int escPrcnt=1 ) ;

/* parsing comands */
extern void	listing    (char*) ;
extern void	usermanHTML(char*, Entry*) ;
extern void	usermanTeX (char*, Entry*) ;
extern void	parseCpp   (Entry* ) ;
extern void	parseJava  (Entry* ) ;
extern void	parseDoc   (Entry* ) ;

extern void	getRefNames( McDArray<McString*>, const char* ) ;
extern Entry*	getRefEntry(const char *name, Entry *entry);
extern Entry*	getRefEntry(McString &name, Entry *entry);
extern void	makeSubLists( Entry* rt ) ;
extern void	entry2link( McString& u, Entry* ref,const char *linkname=0);

extern void	readfile( McString* in, const char* file, int startLine,
			  const char *directory=0, int scanSubDirs=0) ;

#define	HAS_BASES(entry)			\
	(  entry->otherPubBaseclasses.size()	\
	|| entry->otherProBaseclasses.size()	\
	|| entry->pubBaseclasses.size()		\
	|| entry->proBaseclasses.size() )

#define	MAKE_DOC(entry)				\
	(  (entry->sub != 0			\
	|| entry->see.size() > 0		\
	|| entry->author.length() > 0		\
	|| entry->author.length() > 0		\
	|| entry->version.length() > 0		\
	|| entry->param.size() > 0		\
	|| entry->retrn.length() > 0		\
	|| entry->exception.size() > 0		\
	|| entry->doc.length() > 0		\
	|| entry->proChilds.size() > 0		\
	|| entry->pubChilds.size() > 0		\
	|| (entry->priChilds.size() > 0	 &&  withPrivate)	\
	|| (entry->parent != 0 && entry->parent->parent == 0)		\
	|| HAS_BASES(entry)) && (!(entry->fromUnknownPackage)) )

#endif
