#include <blitz/array.h>

BZ_USING_NAMESPACE(blitz)

BZ_DECLARE_STENCIL4(testDeriv,A,B,C,D)
  B = Laplacian2D(A);
  C = central42(A,firstDim) + central42(A,secondDim);
  D = central22(A,firstDim) + central22(A,secondDim);
BZ_END_STENCIL

int main()
{
    const int N = 16;

    Array<float,2> A(N,N), B(N,N), C(N,N), D(N,N);
    A = 0;
    A(N/2,N/2) = 1.0;

    Range middle(N/4,3*N/4);
    applyStencil(testDeriv(),A,B,C,D);

    cout << B(middle,middle) << endl
         << C(middle,middle) << endl
         << D(middle,middle) << endl;

    return 0;
}

