/*
 *
 *              This program is free software; you can redistribute it and/or
 *              modify it under the terms of the GNU General Public License
 *              as published by the Free Software Foundation;
 * 		Look at the file LICENSE for details
 *
*/
int waitforchar (int fd,unsigned int secs,unsigned int usecs)
{
  fd_set rfds, testfds;
  struct timeval timer;
  int retval;

/* zero the file set */
  FD_ZERO (&rfds);

/* mark the fd in the set */

  FD_SET (fd, &rfds);
/*
   FD_SET (0, &rfds);
 */
/* wait for input for a maximum of timeout secs+usecs */
  while (1)
    {


      testfds = rfds;
      timer.tv_sec = secs;
      timer.tv_usec = usecs;
      retval = select (fd + 1, &testfds, NULL, NULL, &timer);
      switch (retval)
	{
	case 0:
	  {
	    /* timeout */
	    fprintf (dbg, "\ntimed out after %d secs and %d usecs\n", secs, usecs);
	    return retval;
	    break;		/* unreachable code -- here not to confuse compiler */
	  }
	case -1:
	  {			/* should we just return 0 and life goes on? */
	    perror ("select");
	    return retval;
	    break;		/* unreachable code -- here not to confuse compiler */
	  }
	default:
	  {
	    if (FD_ISSET (fd, &testfds))
	      {
		return 1;
	      }
/*
   if (FD_ISSET(0,&testfds)) {
   terminate();
   }
 */
	  }
	}			/* end switch */
    }
}
/*
*/
disptel1 (casiorec *ourdata)
{
/* jamal -- unacceptable: tels should be in
in casio.h */
char tels[8][32]={"Name","Phone #1","Phone #2","Phone #3","Company","Address","E
mail","Note/Position"};

  int i, count = 0, oldcount = 0;
  tel1 *tel = (tel1 *)ourdata->data;
  if (ourdata->length > 1)
    {
      fprintf (data, "\n%s: ", tels[count]);
/* length-1 because we dont want  the trailing FF 
   unfortunately it comes before /n -- so get rid of both 
   -2 but re-add /n */
      for (i = 0; i < ourdata->length - 2; i++)
	{
	  if (tel->data[i] == 0xB)
	    {
	      fprintf (data, "\n");
	    }
	  else
	    {
	      fprintf (data, "%c", tel->data[i]);
	    }
	  if (tel->data[i] == 0xA)
	    {
	      count++;
	      fprintf (data, "%s: ", tels[count]);
	    }
	}
    }
}

dispmemo (ourdata)
casiorec *ourdata;
{
  memot *memo;
  int i, count = 0, oldcount = 0;
  (casiorec *) memo = ourdata->data;
  fprintf (data, "\ndate: %d/%d/%d ", memo->day, memo->month, memo->year);
  if (ourdata->length > 1)
    {
/* 
   length-1 because we dont want  the trailing FF 
   unfortunately it comes before /n -- so get rid of both 
 */
      fprintf (data, "\ntext: ");
      for (i = 0; i < ourdata->length - 5; i++)
	{
	  if (memo->data[i] == 0xB)
	    {
	      fprintf (data, "\n");
	    }
	  else
	    {
	      fprintf (data, "%c", memo->data[i]);
	    }
	}
    }
}

dispsched1 (ourdata)
casiorec *ourdata;
{
  schd1 *s1;
  int i, count = 0, oldcount = 0;

  (casiorec *) s1 = ourdata->data;
  fprintf (data, "\nstart date: %d/%d/%d ", s1->day, s1->month, s1->year);
  fprintf (data, "\nEnd date: %d/%d/%d ", s1->day2, s1->month2, s1->year2);
  fprintf (data, "\nschedule type: %d", s1->sctype);
  if (ourdata->length > 1)
    {
/* 
   length-1 because we dont want  the trailing FF 
   unfortunately it comes before \n -- so get rid of both 
   -2 but re-add 
 */
      fprintf (data, "\ntext: ");
      for (i = 0; i < ourdata->length - 9; i++)
	{
	  if (s1->data[i] == 0xB)
	    {
	      fprintf (data, "\n");
	    }
	  else
	    {
	      fprintf (data, "%c", s1->data[i]);
	    }
	}
    }
}


dispsched2 (ourdata)
casiorec *ourdata;
{
  schd2 *s2;
  int i, count = 0, oldcount = 0;

  (casiorec *) s2 = ourdata->data;
  fprintf (data, "\ndate: %d/%d/%d ", s2->day, s2->month, s2->year);
  fprintf (data, "\nschedule type: %d", s2->sctype);
  fprintf (data, "\nlenght: %d", ourdata->length - 6);
  if (ourdata->length > 1)
    {
/* 
 */
      fprintf (data, "\ntext: ");
      for (i = 0; i < ourdata->length - 6; i++)
	{
	  if (s2->data[i] == 0xB)
	    {
	      fprintf (data, "\n");
	    }
	  else
	    {
	      fprintf (data, "%c", s2->data[i]);
	    }
	}
    }
}

dispsched3 (ourdata)
casiorec *ourdata;
{
  schd3 *s3;
  int i, count = 0, oldcount = 0;

  (casiorec *) s3 = ourdata->data;
  fprintf (data, "\nchecksum: %d", ourdata->cksum);
  fprintf (data, "\ndate: %d/%d/%d ", s3->day, s3->month, s3->year);
  fprintf (data, "\ntime: %d:%d --> %d:%d", s3->shour, s3->smin, s3->ehour, s3->emin);
  if (s3->ahour == 0xFF)
    {
      fprintf (data, "\nSet Alarm has expired");
    }
  else
    {
      fprintf (data, "\nAlarm set to: %d:%d", s3->ahour, s3->amin);
    }
  fprintf (data, "\nschedule type: %d", s3->sctype);
  if (ourdata->length > 1)
    {
/* 
 */
      fprintf (data, "\ntext: ");
      for (i = 0; i < ourdata->length - 12; i++)
	{
	  if (s3->data[i] == 0xB)
	    {
	      fprintf (data, "\n");
	    }
	  else
	    {
	      fprintf (data, "%c", s3->data[i]);
	    }
	}
    }
}

disptodo (ourdata)
casiorec *ourdata;
{
  todot *todo;
  int i, count = 0, oldcount = 0;
  (casiorec *) todo = ourdata->data;
  fprintf (data, "\ndate: %d/%d/%d ", todo->day, todo->month, todo->year);
  fprintf (data, "\npriority: %d", todo->priority);
  if (ourdata->length > 1)
    {
      fprintf (data, "\ntext: ");
      for (i = 0; i < ourdata->length - 7; i++)
	{
	  if (todo->data[i] == 0xB)
	    {
	      fprintf (data, "\n");
	    }
	  else
	    {
	      fprintf (data, "%c", todo->data[i]);
	    }
	}
    }
}

dispUnknown (ourdata)
casiorec *ourdata;
{
  int i, tot, field = 1;
  byte bufc[257];
  fprintf (data, "\n****** Attempt to format unknown  ******\n");
  fprintf (data, "\ntype: %d\n", ourdata->type);
  tot = ourdata->type;
  fprintf (data, "Field%d ", field);
  for (i = 0; i < ourdata->length; i++)
    {

      if (ourdata->data[i] == 0xA)
	{
	  field++;
	  fprintf (data, "\nField%d ", field);
	}
      if (ourdata->data[i] == 0xB)
	{
	  fprintf (data, "\n");
	}
      else
	{
	  if (isprint (ourdata->data[i]))
	    {
	      /* print into the debug file both the ascii and the hex version */
	      fprintf (data, "%c", ourdata->data[i]);
	      fprintf (dbg, ".%c/%d.", ourdata->data[i], ourdata->data[i]);
	    }
	  else
	    {
	      fprintf (data, "<%x>", ourdata->data[i]);
	      fprintf (dbg, "<%x/%d>", ourdata->data[i], ourdata->data[i]);
	    }

	}
      tot += ourdata->data[i] & 0xff;
    }
  fprintf (data, "\n");
  fprintf (data, "checksum %2x ", ourdata->cksum);
  fprintf (data, "total %2x ", tot & 0xff);
  fprintf (data, "\n*********************************************\n");
}

dispsched (ourdata)
casiorec *ourdata;
{
  switch (ourdata->type)
    {
    case 0x0c:
      {
	dispsched1 ();
	break;
      }
    case 0x0d:
      {
	dispsched2 ();
	break;
      }
    case 0x0e:
      {
	dispsched3 ();
	break;
      }
    default:
      fprintf (data, "\n ####### we dont know how to format this schedule type \n");
      break;
    }

}

dispexp (ourdata)
casiorec *ourdata;
{
  char payt[8][32]={"Cash","Check","Credit Card","other","other1","other2","other3 ","other4"};

  char expt[8][32]={"Meals","Hotel","Car","Phone","Fares","Entertainment","Tips"," Misc."};

  expense *exps;
  int i = 0;
  (casiorec *) exps = ourdata->data;

  fprintf (data, "\nchecksum: %x ", ourdata->cksum);
  fprintf (data, "\ndate: %d/%d/%d ", exps->day, exps->month, exps->year);
  fprintf (data, "\nExpense type: %s ", expt[exps->exptype][0]);
  fprintf (data, "\nPayment type: %s ", payt[exps->paytype][0]);
  fprintf (data, "\nreceipt: %s ", exps->receipt ? "no" : "yes");
  fprintf (data, "\nAmount: ");
  printamount ();
  fprintf (data, "\nData: ");
  for (i = 0; i < ourdata->length - 14; i++)
    {
      if (exps->data[i] == 0xB)
	{
	  fprintf (data, "\n");
	}
      else
	{
	  if (isprint (exps->data[i]))
	    {
	      fprintf (data, "%c", exps->data[i]);
	    }
	  else
	    {
	      fprintf (data, ".");
	    }
	}
    }

}

printamount (ourdata)
casiorec *ourdata;
{
  int rights, remaining, lefts, start = 0, evened = 0, i = 0;
  expense *exps;
  (casiorec *) exps = ourdata->data;

  while (i <= 4)
    {
      if (exps->amount[i] != 0xFF)
	{
/*
   fprintf(data,"%d:%x",i,exps->amount[i]);
 */
	  break;
	}
      i++;
    }
/*
   fprintf(data,"\n");
 */

/* found the mark */
  if (i >= 4)
    {
      fprintf (data, "\n Corrupt amount");
      return;
    }

  rights = (0x1f - exps->amount[4]);
  remaining = (4 - i) * 2;
  lefts = remaining - rights;

/*
   fprintf(data,"<%d.%d>",lefts,rights);
 */
  for (; i < 4; i++)
    {
      if (!lefts)
	{
/*
   printf(data,"start set");
 */
	  break;
	}
      if ((exps->amount[i] >> 4) != 0xf)
	{
	  fprintf (data, "%x", exps->amount[i] >> 4);
	}
      lefts--;
      if (!lefts)
	{
	  start = 1;
	  break;
	}
      if ((exps->amount[i] & 0x0f) != 0xf)
	{
	  fprintf (data, "%x", exps->amount[i] & 0x0f);
	}
      lefts--;
    }
  fprintf (data, ".");

/*
   The right handside
 */
  if (start)
    {
      if ((exps->amount[i] & 0x0f) != 0xf)
	{
	  fprintf (data, "%x", exps->amount[i] & 0x0f);
	}
      start = 0;
      rights--;
    }

/*
 */

  for (; i < 4; i++)
    {
      if (!rights)
	{
	  break;
	}
      fprintf (data, "%x", exps->amount[i] >> 4);
      rights--;
      if (!rights)
	{
	  break;
	}
      fprintf (data, "%x", exps->amount[i] & 0x0f);
      rights--;

    }

}

disprem (ourdata)
casiorec *ourdata;
{
  remind *reminder;
  int i, count = 0, oldcount = 0;

  (casiorec *) reminder = ourdata->data;
  if (debugmode > 3)
    fprintf (data, "\nchecksum: %x", ourdata->cksum);
  fprintf (data, "\ndate: %d/%d ", reminder->day, reminder->month);
  fprintf (data, "\nnextdate: %d/%d/%d ", reminder->day2, reminder->month2, reminder->year2);
  if (reminder->ahour == 0xFF)
    {
      fprintf (data, "\nSet Alarm has expired");
    }
  else
    {
      fprintf (data, "\nAlarm set to: %d:%d", reminder->ahour, reminder->amin);
    }
  if (ourdata->length > 1)
    {
/* 
 */
      fprintf (data, "\ntext: ");
      for (i = 0; i < ourdata->length - 13; i++)
	{
	  if (reminder->data[i] == 0xB)
	    {
	      fprintf (data, "\n");
	    }
	  else
	    {
	      fprintf (data, "%c", reminder->data[i]);
	    }
	}
    }
}

/*
* invoking this fills up therecs array with casio records
* found in the passed file descriptor
*/
readcasdata(FILE *casiofile)
{
casiorec *temp;
/* move to utils.c */
(int (*))displayers[0]=&disptel1;
(int (*) )displayers[1]=&disptel1;
(int (*) )displayers[2]=&disptel1;
(int (*) )displayers[3]=&dispmemo;
(int (*) )displayers[4]=&dispmemo;
(int (*) )displayers[5]=&dispmemo;
(int (*) )displayers[6]=&disptodo;
(int (*) )displayers[7]=&disptodo;
(int (*) )displayers[8]=&disptodo;
(int (*) )displayers[9]=&dispexp;
(int (*) )displayers[10]=&dispexp;
(int (*) )displayers[11]=&dispexp;
(int (*) )displayers[12]=&dispsched;
(int (*) )displayers[13]=&dispsched;
(int (*) )displayers[14]=&dispsched;
(int (*) )displayers[15]=&disprem;



while (1)
{
/* make the file reader be a single routine which returns
a structure */
/* read the header first */
  if (fread (&MHeader, sizeof (MHeader), 1, casiofile) != 1)
    {
      break;
    }

if (MHeader.ourhead == 0x8a)
{
ourdata.type=MHeader.type;
ourdata.length=MHeader.nbytes;
} else {
/* we need to retry -- not sure if it is a good idea */
continue;
}
/* read the data next */
  if (fread (&ourdata.data, ourdata.length, 1, casiofile) != 1)
    {
      break;
    }
/* read the checksum next */
  if (fread (&ourdata.cksum, sizeof (byte), 1, casiofile) != 1)
    {
      break;
    }

/*
printf("\ntype number: %d ",ourdata.type);
printf("\nlength: %d ",ourdata.length);
displayers[ourdata.type](&ourdata);
*/
/*
We build a linked list here
*/
temp=(casiorec *)malloc(sizeof(ourdata));
if (temp ==NULL)
{
printf("\n tough luck: failed to allocate mem\n");
exit(0);
}
bcopy(&ourdata,temp,sizeof(ourdata));
temp->next=therecs[ourdata.type];
therecs[ourdata.type]=temp;

}

}

/*
* compute the checksum -- return the checksum value
*/

int cas_cksum (ourdata)
casiorec *ourdata;
{
int cksum,i;
cksum=ourdata->type&0xff;
if (debugmode)
printf("\n length: %d",ourdata->length);
        for (i=0;i<ourdata->length;i++)
        {
        cksum+=ourdata->data[i]&0xff;
        cksum&=0xff;
if (debugmode)
        printf("%x ",ourdata->data[i]);
        }
if (debugmode)
printf("\n computed checksum: %d correct checksum: %d\n",
       cksum,ourdata->cksum);
return(cksum);
}

/* 
writes to file a passed casio record;
returns 1 if failure else returns 0
*/

write2file(fd,ourdata)
casiorec *ourdata;
FILE  *fd;
{
int retval;
retval=fwrite (&ourheader, sizeof (byte), 1, fd);
if (retval !=1) return 1;
retval=fwrite (&ourdata->type, sizeof (byte), 1, fd);
if (retval !=1) return 1;
retval=fwrite (&ourdata->length, sizeof (byte), 1, fd);
if (retval !=1) return 1;
retval=fwrite (&ourdata->data, ourdata->length, 1, fd);
if (retval !=1) return 1;
retval=fwrite (&ourdata->cksum, sizeof (byte), 1, fd);
if (retval !=1) return 1;
return 0;
}

