/*
 *	VME Linux/m68k Loader
 *
 *	(c) Copyright 1997 by Nick Holgate
 *
 *	This file is subject to the terms and conditions of the GNU General Public
 *	License.  See the file COPYING for more details.
 */

/*--------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

/*--------------------------------------------------------------------------*/

int
main
(	int		argc,
	char		*argv[]
)
{	FILE		*fp1;
	int		c;
	int		count;

	if (argc != 3)
	{
		printf("Usage : %s <source_file> <label>\n", argv[0]);
		exit(0);
	}

	if ((fp1 = fopen(argv[1], "rb")) == NULL)
	{
		printf("Error opening '%s' for reading!\n", argv[1]);
		exit(1);
	}

	printf("unsigned char %s[] = {", argv[2]);

	count = 0;
	while ((c = getc(fp1)) != EOF)
	{
		if (count)
		{
			putc(',', stdout);
		}
			
		if ((count % 10) == 0)
		{
			printf("\n\t");
		}

		printf("0x%02X", c);

		count++;
	}

	printf("\n};\n");

	fclose(fp1);

	return 0;
}

/*-----------------------------< end of file >------------------------------*/
