// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: widget-thread.h,v 1.2 1998/10/20 04:33:22 jgg Exp $
/* ######################################################################

   Widget Thread Support - Provides funcionality to allow the library
   to function in a multi-threaded environment.

   The Lock class implements a mutex around the widget library. It
   should be aquired whenever a function call into the library from 
   a slave thread is made. Widget functions should NOT ever use this
   mechanism. Locking is implemented in a fashion that is safe for
   recursive operation, unlike posix mutex's.
   
   It is possible to detach from a previously aquire lock for a time, to
   do this you instantiate a Widget::Detach class, while this class is
   in scope you do not have access to the widget library. It is possible
   to use Widget::Lock to reaquire the lock, so long as the lock is not held
   when Widget::Detach goes to re-attach
   
   Syncronous events are used to create dialogs. Their purpose is to allow
   a string of code to execute, bring up a dialog and then wait for the
   dialog to close. This is done with a SNotify class. The original code 
   creates a SNotify instance, stores it someplace (say with the ok button)
   then calls the Wait member. When the OK button is pressed it calls the
   Trigger member which causes Wait to (eventually) exit. It is analogous
   to Condition/Event semaphores. The main distinction is that events
   from the IO processes can still propogate through the widget library.
  
   The detach primitive and Syncronous Event mechanism make it very simple
   and straightforward to create message dialogs in a fashion that does not
   significantly disturb the widget library.
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_WIDGETTHREAD_H
#define DEITY_WIDGETTHREAD_H

#ifdef __GNUG__
#pragma interface "deity/widget-thread.h"
#endif  

#include <deity/widget.h>
#include <deity/notify.h>
#include <pthread.h>

// Syncronized notification
class SNotify : public Notifyer
{
   pthread_cond_t WaitCond;
   pthread_mutex_t WaitMutex;
   int Counter;
   
   public:
   
   void Trigger();
   virtual bool Trigger(Widget *,Tag,void *) {Trigger(); return true;};
   void Wait();
   
   SNotify(Tag Id = Tag());
   ~SNotify();
};

// Widget lib locking class
class Widget::Lock
{  
   protected:
   
   static pthread_mutex_t Mutex;
   static unsigned int Depth;
   static pthread_t Owner;
   bool Connected;
   
   public:
   friend Widget::Detach;
   
   void Detach();
   static bool IsOwner();
   
   Lock();
   inline ~Lock() {Detach();};
};   

class Widget::Detach
{
   protected:
   
   bool Connected;
   unsigned int OldDepth;
   
   public:
   
   void Connect();
   
   Detach();
   inline ~Detach() {Connect();};
};

#endif
