// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: utils.h,v 1.5 1998/09/12 02:46:46 jgg Exp $
/* ######################################################################
   
   General Utility Functions
   
   ###################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_UTILS_H
#define DEITY_UTILS_H

#ifdef __GNUG__
#pragma interface "deity/utils.h"
#endif  

#include <deity/widget.h>

// Min/Max functions
#if defined(__HIGHC__)
#define MIN(x,y) _min(x,y)
#define MAX(x,y) _max(x,y)
#endif

// GNU C++ has a min/max operator <coolio>
#if defined(__GNUG__)
#define MIN(A,B) ((A) <? (B))
#define MAX(A,B) ((A) >? (B))
#endif

/* Templates tend to mess up existing code that uses min/max because of the
   strict matching requirements */
#if !defined(MIN)
#define MIN(A,B) ((A) < (B)?(A):(B))
#define MAX(A,B) ((A) > (B)?(A):(B))
#endif

#define _count(a) (sizeof(a)/sizeof(a[0]))

// General things
void ReAttachStreams();

// Layout tools
Point ChildrenExtent(Widget *Target);
void HorizontalLayout(Widget *Target,long Spacing);
long VerticalLayout(Widget *Target,long Spacing = 0,bool SameSize = true);
double GetCurrentTime();
void CenterWidget(Widget *Target,Rect Box);

#endif
