// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: columnbar.h,v 1.2 1998/08/27 04:09:38 jgg Exp $
/* ######################################################################

   Column Bar - A horizontal bar providing titles for columns
   
   This class was designed to be used with a tree to provide it with
   columns. It accepts a string of \t,\e separated names and a list of
   longs indicating the column spacing.

   \t indicates the item should be left aligned in the column.
   \e indicates the item should be centered in the column.
   
   Other widgets can get the pixel offsets of the items with the 
   PixelPosition member. This allows the column bar's alignment to 
   contol spacing of other widgets.

   Setting the size of a column to -200 will cause the column to be
   disabled and not displayed.
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_COLUMNBAR_H
#define DEITY_COLUMNBAR_H

#ifdef __GNUG__
#pragma interface "deity/columnbar.h"
#endif  

#include <deity/basic.h>

class ColumnBar : public BasicWidget
{
   protected:
   
   string Columns;
   long *Positions;
   unsigned int Count;
   
   virtual void Render(CombinedGC &GC);
   virtual Point IdealSize();
   
   public:

   // Return the Pixel values from Pos.x of each column.
   long PixelPositions(long *Pos, int Max);

   // Set the positions values
   void Position(long *Pos, int Max);
      
   ColumnBar(string Columns,Widget *Parent = 0);
};

#endif
