# copyright (C) 1997-1999 Jean-Luc Fontaine (mailto:jfontain@multimania.com)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: preferen.tcl,v 1.7 1999/08/08 18:31:40 jfontain Exp $}

namespace eval preferences {

    # there is no knowledge in this file about which global variables are handled in preferences: only each folder namespace code
    # in the configuration interfeace knows and deals with them

    variable rcFileName ~/.moodssrc
    variable variables {}

    proc read {} {
        variable rcFileName
        variable variables

        if {![file readable $rcFileName]} {
            return {}
        }
        set file [::open $rcFileName] ;### detect errors and report failures to user ###
        set list {}
        foreach {name value} [::read $file] {
            set name [namespace tail $name]     ;# moodss versions before 8.1 wrote fully qualified names (such as global::variable)
            variable $name $value                                                                    ;# initialize in this namespace
            lappend list $name $value
        }
        close $file
        return $list
    }

    proc save {variables} {                                                                                       ;# save to rc file
        # at this point, variables in this namespace have been updated in the configuration interface
        variable rcFileName

        set file [::open $rcFileName w] ;### detect errors and report failures to user ###
        set list {}
        foreach name $variables {
            lappend list $name [set ::preferences::$name]
        }
        puts -nonewline $file $list
        close $file
    }

}
