#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include "misc.p"

int main (int argc, char *argv[])
{
	int ret = -1;
	int head = -1;
	int tail = -1;
	const char *fsend = NULL;
	int i;
	for (i=1; i<argc; i++){
		const char *arg = argv[i];
		const char *nextarg = argv[i+1];
		if (nextarg == NULL) nextarg = "-1";
		if (strcmp(arg,"--head")==0){
			head = atoi(nextarg);
			i++;
		}else if (strcmp(arg,"--tail")==0){
			tail = atoi(nextarg);
			i++;
		}else if (strcmp(arg,"--send")==0){
			fsend = nextarg;
			i++;
		}else{
			break;
		}
	}
	if (i +2 != argc) {
		fprintf (stderr,"netcat [ --head nb_lines ] [ --tail nb_lines ]\n");
		fprintf (stderr,"       [ --send file ]\n");
		fprintf (stderr,"       host service\n");
	}else{
		const char *portstr = argv[i+1];
		int fd = -1;
		if (isdigit(*portstr)){
			fd = sockutil_connectn (argv[i],atoi(portstr),1);
		}else{
			fd = sockutil_connect (argv[i],portstr,1);
		}
		if (fd != -1){
			char buf[300];
			char line[1000];
			int noline = 0;
			int done = 0;
			int nb;
			if (fsend != NULL){
				FILE *fin = fopen (fsend,"r");
				if (fin == NULL){
					fprintf (stderr,"Can't open %s (%s)\n",fsend
						,strerror(errno));
				}else{
					while (fgets (line,sizeof(line)-1,fin)!=NULL){
						write (fd,line,strlen(line));
					}
					fclose (fin);
				}
			}
			line[0] = '\0';
			while (!done
				&& (nb=read (fd,buf,sizeof(buf)-1))> 0){
				char *pt = buf;
				buf[nb] = '\0';
				while (*pt != '\0'){
					char *start = pt;
					pt = strchr(pt,'\n');
					if (pt != NULL){
						*pt++ = '\0';
						strcat (line,start);
						if (noline < head){
							printf ("%s\n",line);
							noline ++;
							if (noline == head) done = 1;
						}else if (tail > 0){
						}else{
							printf ("%s\n",line);
						}
						line[0] = '\0';
					}else{
						strcat (line,start);
						break;
					}
				}
			}
			if (head > 0){
				if (noline < head) printf ("%s\n",line);
			}else if (tail > 0){
			}else{
				printf ("%s",line);
			}
			ret = 0;
		}
	}
	return ret;
}

