#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#define MAXLEN_DICTNAME	19

#ifndef MISC_H
	#include "misc.h"
#endif

class LANG_STRING: public ARRAY_OBJ{
public:
	char lang;
	SSTRING str;
	/*~PROTOBEG~ LANG_STRING */
public:
	LANG_STRING (char _lang, const char *_str);
	/*~PROTOEND~ LANG_STRING */
};


class LANG_STRINGS: public ARRAY{
	/*~PROTOBEG~ LANG_STRINGS */
public:
	LANG_STRING *getitem (int no);
	/*~PROTOEND~ LANG_STRINGS */
};

class TR_STRING: public ARRAY_OBJ{
protected:
	int changed;
	SSTRING id;
	SSTRING comment;
	SSTRING origin;		// Source file declaring this message
						// This info is not actually saved in the dictionnary
	LANG_STRINGS tb;
	/*~PROTOBEG~ TR_STRING */
public:
	TR_STRING (const char *_id);
	void add2comment (const char *_comment);
	void deltranslation (char lang);
	const char *getid (void);
	const char *getmsg (char lang);
	int getnblang (void);
	const char *getorigin (void);
	LANG_STRING *gettranslation (char lang);
	void reset_changed (void);
	void setorigin (const char *str);
	SSTRING *settranslation (char lang, const char *str);
	int was_changed (void);
	void write (FILE *fout);
	/*~PROTOEND~ TR_STRING */
};

class TR_STRINGS: public ARRAY{
	int version;
	/*~PROTOBEG~ TR_STRINGS */
public:
	TR_STRINGS (void);
	void deltranslation (char lang);
	TR_STRING *getitem (const char *id);
	TR_STRING *getitem (int no);
	int getversion (void);
	int read (const char *fname);
	void setversion (int ver);
	void showold (char deflang);
	int write (const char *fname);
	int write_mod (const char *fname);
	int writeh (const char *sysname, const char *fname);
	/*~PROTOEND~ TR_STRINGS */
};

// Structures for the compiled dictionnary


#define BDICT_MAGIC	0x9867
#define BDICT_VERSION	4
struct BDICT_HEADER{
	short unsigned magic;
	short unsigned version;
	int nbsys;	// Number of systems (make sure the structure is aligned)
};

struct BDICT_SYSTEM{
	char name[MAXLEN_DICTNAME+1];	// Name of the system
	short int version;
	short pad;		// For certain architectures the
					// compiler doesn't generate 4-byte
					// alignment on shorts
					// - we must do it manually!
	int nbmsg;		// Number of message	(alignment)
};

#ifndef _STDIO_H
	#include <stdio.h>
#endif

class TRANS_NOTLOAD;

#include "translate.p"

#endif
