#include <stdio.h>

int main (int argc, char *argv[])
{
	const char *prefix = "192.168.1";
	if (argc == 2) prefix = argv[1];
	int nbnet = 2;
	int bit = 128;
	int mask = 0;
	const char *ctl = "%-17s%-17s%-17s%-17s\n";
	printf (ctl,"Netmask","Networkadr","Start","Stop");
	for (int i=0; i<6; i++, nbnet *= 2, bit >>=1){
		mask |= bit;
		int adr = 0;
		for (int n=0; n<nbnet; n++, adr += bit){
			char maskstr[20];
			maskstr[0] = '\0';
			if (n == 0){
				printf ("\n");
				sprintf (maskstr,"255.255.255.%d",mask);
			}
			char adrstr[20];
			sprintf (adrstr,"%s.%d",prefix,adr);
			char start[20],stop[20];
			sprintf (start,"%s.%d",prefix,adr+1);
			sprintf (stop,"%s.%d",prefix,adr+bit-2);
			printf (ctl,maskstr,adrstr,start,stop);
		}
	}
	return 0;
}

