#include <stdlib.h>
#include <fviews.h>
#include <configf.h>
#include <subsys.h>
#include <translat.h>
#include "squid.h"
#include "squid.m"
#include "../module_apis/package_api.h"

static HELP_FILE help_squid ("squid","squid");

static const char subsys_squid[]="squid";
static LINUXCONF_SUBSYS subb (subsys_squid,P_MSG_R(M_squid));


static CONFIG_FILE f_squid ("/etc/squid/squid.conf",help_squid
		,CONFIGF_OPTIONNAL|CONFIGF_MANAGED,subsys_squid);

class SQUID{
	VIEWITEMS items;
	/*~PROTOBEG~ SQUID */
public:
	SQUID (void);
	int editacl (void);
	int editdefaults (void);
	void editmain (void);
	int write (void);
	/*~PROTOEND~ SQUID */
};


PUBLIC SQUID::SQUID()
{
	items.read (f_squid);
}

PUBLIC int SQUID::write()
{
	return items.write (f_squid,NULL);
}

class ITEM_COMMON{
protected:
	const char *name;	// Name of the feature
	VIEWITEM *item;		// Pointer into items
	/*~PROTOBEG~ ITEM_COMMON */
public:
	ITEM_COMMON (VIEWITEMS&items,
		 const char *_varname);
	void del (VIEWITEMS&items);
	void save (VIEWITEMS&items);
	/*~PROTOEND~ ITEM_COMMON */
};

PUBLIC ITEM_COMMON::ITEM_COMMON(
	VIEWITEMS &items,
	const char *_varname)
{
	name = _varname;
	item = items.locate (_varname);
}
	
PUBLIC void ITEM_COMMON::save(VIEWITEMS &items)
{
	if (item == NULL){
		item = new VIEWITEM("");
		items.add (item);
	}
}

PUBLIC void ITEM_COMMON::del(VIEWITEMS &items)
{
	if (item != NULL) items.remove_del (item);
}

class ITEM_INT: public ITEM_COMMON{
public:
	int val;			// Current value for edition
	/*~PROTOBEG~ ITEM_INT */
public:
	ITEM_INT (VIEWITEMS&items,
		 const char *_varname,
		 int defval);
	void save (VIEWITEMS&items);
	/*~PROTOEND~ ITEM_INT */
};

PUBLIC ITEM_INT::ITEM_INT(
	VIEWITEMS &items,
	const char *_varname,
	int defval)
	: ITEM_COMMON (items,_varname)
{
	val = defval;
	if (item != NULL){
		const char *line = item->line.get();
		line = str_skipword (line);
		line = str_skip(line);
		val = atoi (line);
	}
}
	
PUBLIC void ITEM_INT::save(VIEWITEMS &items)
{
	ITEM_COMMON::save(items);
	char buf[1000];
	snprintf (buf,sizeof(buf)-1,"%s %d",name,val);
	item->line.setfrom (buf);
}

class ITEM_STR: public ITEM_COMMON{
public:
	SSTRING val;			// Current value for edition
	/*~PROTOBEG~ ITEM_STR */
public:
	ITEM_STR (VIEWITEMS&items,
		 const char *_varname,
		 const char *defval);
	void save (VIEWITEMS&items);
	/*~PROTOEND~ ITEM_STR */
};

PUBLIC ITEM_STR::ITEM_STR(
	VIEWITEMS &items,
	const char *_varname,
	const char *defval)
	: ITEM_COMMON (items,_varname)
{
	val.setfrom (defval);
	if (item != NULL){
		const char *line = item->line.get();
		line = str_skipword (line);
		line = str_skip(line);
		val.setfrom (line);
	}
}

PUBLIC void ITEM_STR::save(VIEWITEMS &items)
{
	ITEM_COMMON::save(items);
	char buf[1000];
	snprintf (buf,sizeof(buf)-1,"%s %s",name,val.get());
	item->line.setfrom (buf);
}


class ITEM_BOOL: public ITEM_COMMON{
public:
	char val;			// Current value for edition
	/*~PROTOBEG~ ITEM_BOOL */
public:
	ITEM_BOOL (VIEWITEMS&items,
		 const char *_varname,
		 int defval);
	void save (VIEWITEMS&items);
	/*~PROTOEND~ ITEM_BOOL */
};

PUBLIC ITEM_BOOL::ITEM_BOOL(
	VIEWITEMS &items,
	const char *_varname,
	int defval)
	: ITEM_COMMON (items,_varname)
{
	val = defval != 0;
	if (item != NULL){
		const char *line = item->line.get();
		line = str_skipword (line);
		line = str_skip(line);
		val = stricmp(line,"on")==0;
	}
}


	
PUBLIC void ITEM_BOOL::save(VIEWITEMS &items)
{
	ITEM_COMMON::save(items);
	char buf[1000];
	snprintf (buf,sizeof(buf)-1,"%s %s",name,val ? "on" : "off");
	item->line.setfrom (buf);
}


PUBLIC int SQUID::editdefaults()
{
	int ret = -1;
	bool squid2 = true;
	PACKAGE_API *api = package_api_init("squid");
	if (api != NULL){
		int status = api->is_newer (api,"squid","2");
		if (status >= 0) squid2 = status == 1;
		package_api_end(api);
	}
	DIALOG dia;
	ITEM_INT port (items,"http_port",3128);
	dia.newf_num (MSG_U(F_HTTPPORT,"Http port"),port.val);
	ITEM_INT cachesize (items,"cache_swap",100);	// Squid 1
	char tmp[PATH_MAX];
	snprintf (tmp,sizeof(tmp)-1,"%s 100 16 256"
		,configf_lookuppath("/var/spool/squid"));
	ITEM_STR cachedir (items,"cache_dir",tmp);
	struct {
		SSTRING dir;
		int size;
		int level1;
		int level2;
	}dir_spec;
	if (squid2){
		const char *pt = dir_spec.dir.copyword (cachedir.val.get());
		sscanf (pt,"%d %d %d",&dir_spec.size,&dir_spec.level1
			,&dir_spec.level2);
		dia.newf_num (MSG_U(F_CACHESIZE,"Disk cache size (meg)")
			,dir_spec.size);
	}else{
		dia.newf_num (MSG_R(F_CACHESIZE),cachesize.val);
	}
	ITEM_STR cachemem (items,"cache_mem","8 MB");
	int ramsize = cachemem.val.getval();
	dia.newf_num (MSG_U(F_CACHEMEM,"Ram cache size (meg)"),ramsize);

	ITEM_STR accel (items,"httpd_accel","");
	ITEM_STR accel_host (items,"httpd_accel_host","");
	ITEM_INT accel_port (items,"httpd_accel_port",80);
	SSTRING realhost;
	int realport = 80;
	if (squid2){
		realhost.setfrom (accel_host.val);
		realport = accel_port.val;
	}else{
		const char *pt = accel.val.get();
		if (pt[0] != '\0'){
			pt = realhost.copyword(pt);
			pt = str_skip(pt);
			realport = atoi(pt);
		}
	}
	char transpar = 0;
	if (realhost.cmp("virtual")==0){
		transpar = 1;
		realhost.setfrom ("");
	}
	dia.newf_chk ("",transpar,MSG_U(F_TRANSPAR,"Enable transparent proxying"));
	int field_accel = dia.getnb();
	dia.newf_str (MSG_U(F_REALHOST,"Accelator for host"),realhost);
	dia.newf_num (MSG_U(F_REALPORT,"On port"),realport);

	ITEM_BOOL accelproxy (items,"httpd_accel_with_proxy",0);
	dia.newf_chk ("",accelproxy.val,MSG_U(F_ACCELPROXY,"Accelarator mode + proxy"));

	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_SQUIDDEF,"Squid defaults")
			,MSG_U(I_SQUIDDEF,"You set here the basic operational parameters")
			,help_squid
			,nof);
		if (code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else if (transpar && !realhost.is_empty()){
			xconf_error (MSG_U(E_TRANSACCEL
				,"Can't be both a transparent proxy\n"
				 "and an accelerator"));
			nof = field_accel;
		}else{
			port.save(items);
			accelproxy.save(items);
			if (squid2){
				cachemem.val.setfromf ("%d MB",ramsize);
				cachedir.val.setfromf ("%s %d %d %d",dir_spec.dir.get()
					,dir_spec.size,dir_spec.level1,dir_spec.level2);
				cachedir.save(items);
				accel_port.val = realport;
				accel_port.save(items);
				if (transpar){
					accel_host.val.setfrom ("virtual");
					accel_host.save(items);
				}else if (!realhost.is_empty()){
					accel_host.val.setfrom (realhost);
					accel_host.save(items);
				}else{
					accel_host.del(items);
				}
			}else{
				cachemem.val.setfrom (ramsize);
				cachesize.save(items);
				if (transpar){
					accel.val.setfromf ("virtual %d",realport);
					accel.save(items);
				}else if (!realhost.is_empty()){
					accel.val.setfromf ("%s %d",realhost.get(),realport);
					accel.save(items);
				}else{
					accel.del(items);
				}
			}
			cachemem.save(items);
			ret = write();
			break;
		}
	}
	return ret;
}

PUBLIC int SQUID::editacl()
{
	return 0;
}


PUBLIC void SQUID::editmain()
{
	static const char *m_def = MSG_U(M_DEFAULT,"Defaults");
	static const char *m_acl = MSG_U(M_ACL,"Access control");
	static const char *menuopt[]={
		"",		m_def,
		"",		m_acl,
		NULL,
	};
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt);
	int choice=0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_SQUID,"Squid administration")
			,MSG_U(I_SQUID,"This menu allows to configure the Squid proxy server")
			,help_squid
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			if (key == m_def){
				editdefaults();
			}else if (key == m_acl){
				editacl();
			}
		}
	}	
}

void squid_edit()
{
	SQUID sq;
	sq.editmain();
}

