/* ***********
	This module handle the squid proxy + cache server

   ***********
*/
#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "squid.h"
#include "squid.m"

MODULE_DEFINE_VERSION(squid);

PUBLIC MODULE_squid::MODULE_squid()
	: LINUXCONF_MODULE("squid")
{
	linuxconf_loadmsg ("squid",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_squid::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_squid,"Squid (http proxy + cache)");
		dia.new_menuitem ("squid","",keymenu);
	}
}

PUBLIC int MODULE_squid::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			squid_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_squid::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"squid")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module squid\n"
		 "\n"
		 "    No command line option\n")
		);
}

PUBLIC int MODULE_squid::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"squid")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_squid squid;

