#include "diawxxt.h"

PUBLIC COMBO_LIST::COMBO_LIST (COMBO *_cm, int x, int y)
	: MAINFORM (_cm->getframe(),"",x,y,wxTRANSIENT)
{
	cm = _cm;
}

PUBLIC void COMBO_LIST::OnEvent(wxMouseEvent & event)
{
	int it = locate_butfill (event);
	if (it != -1){
		int sel = atoi(tbc[it]->id);
		cm->select (sel);
		dispose();
		cm->mf = NULL;
	}
}


PUBLIC COMBO_ITEM::COMBO_ITEM(const char *_val1, const char *_val2)
{
	val1 = strdup(_val1);
	val2 = strdup(_val2);
	next = NULL;
}

PUBLIC COMBO_ITEM::~COMBO_ITEM()
{
	free ((char*)val1);
	free ((char*)val2);
}

static void button_func (wxObject &o, wxCommandEvent &)
{
	wxButton *b = (wxButton*)&o;
	COMBO *p = (COMBO*)b->GetParent();
	p->showlist();
}


PUBLIC COMBO::COMBO (
	MFORM *_parent,
	const char *initval,
	int cols,
	bool listonly)		// Only member of the help list allowed
	: MFORM (_parent,"")
{
	if (listonly){
		text = NULL;
		char tmp[100];
		sprintf (tmp,"%-*.*s",cols,cols,initval);
		New_buttonfill ("",tmp);
	}else{
		text = New_string (cols,initval);
	}
	MFORM_C *m = alloc_mf();
	wxButton *ret = new wxButton(this,button_func," ");
	m->c = ret;
	m->type = T_BUTTON;

	mf = NULL;
	last = first = NULL;
	nbitem = 0;
	pickverbose = false;
}

PUBLIC COMBO::~COMBO()
{
	if (mf != NULL) mf->dispose();
}

PUBLIC void COMBO::OnEvent(wxMouseEvent & event)
{
	int it = locate_butfill (event);
	if (it != -1){
		showlist();
	}
}


PUBLIC void COMBO::addItem (const char *val1, const char *val2)
{
	COMBO_ITEM *item = new COMBO_ITEM (val1,val2);
	if (first == NULL) first = item;
	if (last != NULL) last->next = item;
	last = item;
	nbitem++;
}
PUBLIC void COMBO::showlist()
{
	if (mf != NULL){
		mf->dispose();
		mf = NULL;
	}else{
		//const char *cur = text->GetValue();
		int absx = 0;
		int ww;
		int absy;
		GetSize (&ww,&absy);
		ClientToScreen (&absx,&absy);
		mf = new COMBO_LIST (this,absx,absy);
		int no = 0;
		COMBO_ITEM *item = first;
		pickverbose = true;
		while (item != NULL){
			const char *val1 = item->val1;
			if (strcmp(val1," ")!=0 && val1[0] != '\0') pickverbose = false;
			char tmp[5];
			sprintf (tmp,"%d",no);
			mf->New_buttonfill (tmp,val1);
			mf->New_buttonfill (tmp,item->val2);
			mf->Newline();
			no++;
			item = item->next;
		}
		mf->Popup();
	}
}
PUBLIC const char *COMBO::getText()
{
	return text != NULL ? text->GetValue() : tbc[0]->s;
}
PUBLIC void COMBO::setText(const char *val)
{
	if (text != NULL) text->SetValue((char*)val);
}
PUBLIC void COMBO::select (int no)
{
	COMBO_ITEM *item = first;
	while (item != NULL){
		if (no == 0){
			const char *val = pickverbose
				? (char*)item->val2
				: (char*)item->val1;
			if (text != NULL){
				text->SetValue ((char*)val);
			}else{
				tbc[0]->sets (val);
				Clear();
				OnPaint();
			}
			break;
		}
		item = item->next;
		no--;
	}
}


