#include <stdio.h>
#include <string.h>
#include "diadef.h"
#include "dialog.h"
#include "internal.h"

PRIVATE void DIALOG::showtimeout(WINDOW *win)
{
	int t = dialog_getcurtimeout();
	if (t > 0){
		wmove(win, internal->height-1,internal->width-6);
		wattrset(win, dialog_attr);
		char buf[10];
		sprintf (buf,"%3d ",t);
		waddstr (win,buf);
	}
}

PRIVATE void DIALOG::showterm (int nof, int but_options)
{
	if (internal->cursw == NULL){
		internal->cursw = dialog_openwin (internal->height,internal->width);
	}
	if (nof >= getnb()) nof = getnb()-1;
	if (nof < 0) nof = 0;
	if (nof < internal->offset){
		setoffset (nof);
	}else if (nof >= internal->offset + internal->nbvisible){
		int newoff = nof;
		if (newoff + internal->nbvisible > getnb()){
			newoff = getnb() - internal->nbvisible;
		}
		setoffset (newoff);
	}
	draw(internal->cursw);
	wrefresh(internal->cursw);
}

PRIVATE MENU_STATUS DIALOG::editterm(
	int &nof,
	int but_options)
{
	MENU_STATUS ret = MENU_NULL;
	WINDOW *dialog = internal->cursw;
	skipprotect (nof,KEY_DOWN,dialog);
	dialog_starttimeout();
	showtimeout(dialog);
	int last_nof = nof;
	bool arrow_up = false;
	bool arrow_down = false;
	while (ret == MENU_NULL) {
		drawarrow_if (dialog,internal->offset>0,arrow_up,true,ACS_UARROW);
		drawarrow_if (dialog,internal->offset+internal->nbvisible<getnb()
			,arrow_down,false,ACS_DARROW);
		if (internal->button == -1){
			if (last_nof != nof
				&& last_nof >= internal->offset
				&& last_nof < internal->offset + internal->nbvisible){
				getitem(last_nof)->unselect(dialog);
			}
			if (nof >= 0 && nof < getnb()){
				getitem(nof)->setcursor (dialog);
			}
			last_nof = nof;
		}
		int key = dialog_wgetch(internal->cursw,ret);
		/* #Specification: F3 key / escape
			F3 was not used in Linuxconf and some people claims it
			is fairly common as an equivalent for the escape key.
			So linuxconf support both! Comments are welcome.
		*/
		if (key == ESC || key == KEY_F(3)){
			ret = MENU_ESCAPE;
			break;
		}else if (ret == MENU_INTERNAL_TIMEOUT){
			// Update the timeout counter at the bottom
			showtimeout(dialog);
			ret = MENU_NULL;
		}else if (ret != MENU_NULL){
			break;
		}else if (internal->button != -1 || key == KEY_F(1)){
			ret = internal->buttons->dokey (dialog,key,internal->button
				,getnb()>0);
		}else if (keymove(dialog,key,nof)==-1){
			switch (key) {
			case TAB:
				internal->button = 0;
				internal->buttons->draw(dialog,internal->button);
				break;
			case '\n':
				if (but_options & MENUBUT_OK){
					ret = MENU_OK;
				}else if (getnb()==1){
					/* #Specification: dialogue / single field case
						A <enter> in a dialogue with a single
						field exit as the first button
						was selected (Generally <Accept>)
						
						If the dialog contain a <Ok> button
						it does the same whatever the number
						of fields. This is a special case for
						menu dialog.
					*/
					internal->button = 0;
					ret = internal->buttons->dokey (dialog,key
						,internal->button,1);
				}else{
					keymove (dialog,KEY_DOWN,nof);
				}
				break;
			default:
				if (nof < getnb() && nof > -1) {
					FIELD_MSG msg;
					getitem(nof)->dokey (dialog,key,msg);
					if (msg.is_loaded) processmsg(dialog,msg);
				}
			}
		}
	}
	attr_clear(stdscr, LINES, COLS, screen_attr);
	wnoutrefresh(stdscr);
	delwin(internal->cursw);
	internal->cursw = NULL;
	return ret;
}

