#include <string.h>
#include "diadef.h"
#include "dialog.h"
#include "../diajava/proto.h"

class FIELD_TITLE: public FIELD_STRING{
	int level;
	const char *pad;
	/*~PROTOBEG~ FIELD_TITLE */
public:
	FIELD_TITLE (const char *_pad,
		 int _level,
		 const char *_prompt,
		 const char *_str);
	void drawtxt (WINDOW *win);
	const char *getmenustr (void)const;
	int getnotepadlevel (void)const;
	void gui_draw (int nof, int &booklevel);
	void html_draw (int);
	int html_validate (int);
	~FIELD_TITLE (void);
	/*~PROTOEND~ FIELD_TITLE */
};

class FIELD_HEAD: public FIELD_TITLE{
	bool is_list;
	int tbcol[DIALOG_MAXCOL];
	/*~PROTOBEG~ FIELD_HEAD */
public:
	FIELD_HEAD (const char *_prompt,
		 const char *_msg,
		 bool _is_list);
	void drawtxt (WINDOW *win);
protected:
	int getwidths (int tb[], int &reset);
public:
	void gui_draw (int , int &);
	void html_draw (int);
	void setwidths (int total_width, int tb[]);
	/*~PROTOEND~ FIELD_HEAD */
};


PUBLIC FIELD_TITLE::FIELD_TITLE(
	const char *_pad,
	int _level,
	const char *_prompt,
	const char *_str)
	: FIELD_STRING (_prompt,(char*)_str,strlen(_str))
{
	level = _level;
	pad = NULL;
	if (_pad != NULL) pad = strdup(_pad);
	readonly = 1;
}

PUBLIC FIELD_TITLE::~FIELD_TITLE()
{
	free ((char*)pad);
}

PUBLIC const char *FIELD_TITLE::getmenustr() const
{
	return buf;
}

PUBLIC void FIELD_TITLE::drawtxt(WINDOW *win)
{
	// Draw an horizontal line
	wmove(win, box.y, box.x);
	wattrset(win, inputbox_attr);
	if (strcmp(buf,"-")==0){
		// Special case, draw a small separator
		for (int i=0; i<10; i++) waddch(win, ACS_HLINE);
	}else{
		for (int i = 0; i < box.width; i++) waddch(win, ACS_HLINE);
		// Draw the text in the middle
		int len = strlen(buf);
		if (len > 0){
			wmove(win, box.y, box.x + (box.width-len)/2);
			waddstr(win, buf);
		}
	}
}

/*
	Draw the field with the prompt
*/
PUBLIC void FIELD_TITLE::html_draw(int)
{
	if (strcmp(buf,"-")==0){
		html_printf ("<tr><td>%s<td><hr>\n",prompt);
	}else{
		const char *option = linuxconf_getval ("html","menutitle"
			,"align=center bgcolor=\"#000066\"");
		const char *font = linuxconf_getval ("html","menutitlefont"
			,"color=\"#ffffff\"");
		html_printf ("<tr><td>%s<th colspan=10 %s>"
			"<font %s><strong>%s</strong></font>\n"
			,prompt,option,font,buf);
	}
}

/*
	Draw the titie field with the prompt
*/
PUBLIC void FIELD_TITLE::gui_draw(int nof, int &booklevel)
{
	if (level == 0){
		if (prompt[0] != '\0') diagui_send_Label (prompt);
		if (strcmp(buf,"-")==0){
			diagui_sendcmd (P_Hline,"\n");
		}else{
			char tmp[1000];
			diagui_sendcmd (P_Hline,"%s\n",diagui_quote(buf,tmp));
		}
		diagui_sendcmd (P_Dispolast,"l 10 c 1\n");
	}else{
		const char *t = pad;
		if (t == NULL) t="";
		if (level == booklevel){
			diagui_sendcmd (P_End,"\n");
		}else if (booklevel > level){
			for (int l=booklevel; l> level; l--){
				diagui_sendcmd (P_End,"\n");
				diagui_sendcmd (P_End,"\n");
			}
			diagui_sendcmd (P_End,"\n");
		}else if (level > booklevel){
			diagui_sendcmd (P_Book,"b%d\n",nof);
		}
		char tmp[1000];
		diagui_sendcmd (P_Page,"p %s\n",diagui_quote(pad,tmp));
		booklevel = level;
	}
}

/*
	Return the notepad level. 0 for no notepad
*/
PUBLIC int FIELD_TITLE::getnotepadlevel() const
{
	return level;
}

PUBLIC int FIELD_TITLE::html_validate(int)
{
	return 0;
}


/*
	Add a new field/title.
	A field/title act as a splitter between to logical section
	of a dialog

	There are 3 cases:

	msg contain a string. It will appear centered with horizontal
	rules on each side.

	msg is empty. A single horizontal rule will be drawn filling the line.

	msg is "-". A left justified horizontal rule will be drawn, not filling
	the line.
*/
PUBLIC void DIALOG::newf_title(
	const char *pad,		// Name of the pad in the notebook
							// or NULL is this is only a separator
	int level,				// 1 for the main notepad, 2 for a subnotepad
	const char *prompt,
	const char *msg)
{
	FIELD_TITLE *ti = new FIELD_TITLE(pad,level,prompt,msg);
	add (ti);
}

PUBLIC void DIALOG::newf_title(const char *prompt, const char *msg)
{
	newf_title (NULL,0,prompt,msg);
}

PUBLIC FIELD_HEAD::FIELD_HEAD(
	const char *_prompt,
	const char *_msg,
	bool _is_list)		// Is it a header in a DIALOG or a DIALOG_RECORDS
						// In DIALOG_RECORDS, we build Clist
	: FIELD_TITLE (NULL,0,_prompt,_msg)
{
	is_list = _is_list;
	is_head = 1;
}

PROTECTED int FIELD_HEAD::getwidths(int tb[], int &reset)
{
	int ret = 0;
	if (strchr(buf,'\t')!=NULL){
		reset = 1;
		ret = menubox_getwidths (buf,tb);
	}
	return ret;
}
PUBLIC void FIELD_HEAD::setwidths (int total_width, int tb[])
{
	memcpy (tbcol,tb,sizeof(tbcol));
	box.width = total_width;
}
PUBLIC void FIELD_HEAD::drawtxt(WINDOW *win)
{
	// Draw an horizontal line
	wmove(win, box.y, box.x);
	wattrset(win, inputbox_attr);
	// This is a heading, not a title
	menubox_drawcols (buf,tbcol,box.width,win);
}

/*
	Draw the field with the prompt
*/
PUBLIC void FIELD_HEAD::html_draw(int)
{
	html_printf ("<tr><td>%s",prompt);
	const char *pt = buf;
	char word[100];
	char *dst = word;
	while (*pt != '\0'){
		if (*pt == '\t'){
			*dst = '\0';
			html_printf ("<td><strong>%s</strong>",word);
			pt++;
			dst = word;
		}else{
			*dst++ = *pt++;
		}
	}
	*dst = '\0';
	html_printf ("<td><strong>%s</strong>\n",word);
}
/*
	Format a Clist or Clist item GUI command
*/
void ftitle_clist (
	int nof,
	const char *tag,
	const char *buf,
	bool is_title,
	const char *dianame,	// FORM name for the setval
	bool setval)			// Updating the value of a line
{
	const char *pt = buf;
	char line[1000];
	char *ptline = line;
	char word[100];
	char *dst = word;
	int nbhead = 1;
	while (*pt != '\0'){
		if (*pt == '\t'){
			*dst = '\0';
			char tmp[1000];
			ptline = stpcpy (ptline,diagui_quote(word,tmp));
			*ptline++ = ' ';
			nbhead++;
			pt++;
			dst = word;
		}else{
			*dst++ = *pt++;
		}
	}
	*dst = '\0';
	*ptline = '\0';
	if (is_title){
		/* #Specification: CLIST / restriction
			We assume that there is only one CLIST in a dialog.
			We simply give it the ID "cl".
		*/
		char tmp2[1000];
		diagui_sendcmd (P_Clist,"cl %d %s %s\n",nbhead
			,line,diagui_quote(word,tmp2));
	}else if (setval){
		char tmp1[1000],tmp2[1000];
		diagui_sendcmd (P_Setval,"%s cl M%d %s %s %s\n",dianame,nof
			,diagui_quote(tag,tmp1),line,diagui_quote(word,tmp2));
	}else{
		char tmp1[1000],tmp2[1000];
		diagui_sendcmd (P_Clist_item,"cl M%d %s %s %s\n",nof
			,diagui_quote(tag,tmp1),line,diagui_quote(word,tmp2));
	}
}

/*
	Draw the head field with the prompt
*/
PUBLIC void FIELD_HEAD::gui_draw(int , int &)
{
	if (is_list){
		ftitle_clist (0,prompt,buf,true,NULL,false);
	}else{
		diagui_send_Label (prompt);
		const char *pt = buf;
		char word[100];
		char *dst = word;
		int nbhead = 1;
		while (*pt != '\0'){
			if (*pt == '\t'){
				*dst = '\0';
				diagui_send_Label (word);
				nbhead++;
				pt++;
				dst = word;
			}else{
				*dst++ = *pt++;
			}
		}
		*dst = '\0';
		diagui_send_Label (word);
		diagui_sendcmd (P_Newline,"\n");
		diagui_sendcmd (P_Skip,"1\n");
		for (int i=0; i<nbhead; i++) diagui_sendcmd (P_Hline,"\n");
	}
}


PUBLIC VIRTUAL void DIALOG::newf_head(const char *prompt, const char *msg)
{
	FIELD_HEAD *he = new FIELD_HEAD(prompt,msg,false);
	add (he);
}
PUBLIC void DIALOG_RECORDS::newf_head(const char *prompt, const char *msg)
{
	FIELD_HEAD *he = new FIELD_HEAD(prompt,msg,true);
	add (he);
}


