#pragma interface
#ifndef DIAJAVA_H
#define DIAJAVA_H

#include <stdio.h>
#ifndef POPEN_H
	#include <popen.h>
#endif

class ITEM_VAL: public ARRAY_OBJ{
public:
	SSTRING diapath;
	SSTRING id;
	SSTRING val;
	/*~PROTOBEG~ ITEM_VAL */
public:
	ITEM_VAL (const char *_diapath,
		 const char *_id,
		 const char *_val);
	/*~PROTOEND~ ITEM_VAL */
};

class ITEM_VALS: public ARRAY{
	/*~PROTOBEG~ ITEM_VALS */
public:
	ITEM_VAL *getitem (int no);
	const char *getval (const char *diapath,
		 const char *id);
	int getvals (const char *diapath,
		 const char *id,
		 SSTRINGS&tb);
	/*~PROTOEND~ ITEM_VALS */
};

class POPENWAITS;

class DIAJAVA{
	POPENFD *pop;
	ITEM_VALS vals;
	/*~PROTOBEG~ DIAJAVA */
public:
	DIAJAVA (bool guiok);
	DIAJAVA (int handlein,
		 int handleout,
		 const char *lines);
	void flush (void);
	const char *getval (const char *diapath,
		 const char *id);
	int getvals (const char *diapath,
		 const char *id,
		 SSTRINGS&tb);
	int is_ok (void);
	void send (const char *ctl, ...);
	void sendcmd (int cmd, const char *ctl, ...);
	int wait (POPENWAITS&tbpopen,
		 char dianame[200],
		 char actionid[100],
		 int &menu,
		 int &but);
	~DIAJAVA (void);
	/*~PROTOEND~ DIAJAVA */
};

struct UISTATE{
	bool leftb;		// left button on
	bool middleb;	// middle button on
	bool rightb;	// right button on
	bool ctrlkey;	// Control key pressed
	bool shiftkey;	// shift key
	bool altkey;
	bool metakey;
};

extern bool diajava_treemenu;
extern bool diajava_reconfdia;
extern bool diajava_setval;
extern bool diajava_gauge;
extern bool diajava_slider;
extern bool diajava_alive;
extern bool diajava_context;



#include <diajava.p>

#endif

