#!/bin/sh
# Just install few modules
# Installe a module if a given control file exist
installif(){
	if [ -f $1 ]; then
		echo Configuration file $1 installed: Enabling module $2
		linuxconf --setmod $2
	fi
}
installif /etc/named.boot dnsconf
installif /etc/named.conf dnsconf
installif /etc/sendmail.cf mailconf
installif /etc/smb.conf samba
installif /etc/httpd/conf/httpd.conf apache
installif /etc/ftpaccess wuftpd
installif /etc/dhcpd.conf dhcpd
installif /usr/bin/fetchmail fetchmailconf
installif /etc/inetd.conf inetdconf


# Install the dialout module if they are some *.dconf
NBDCONF=`ls /etc/ppp/*.dconf 2>/dev/null | wc -l`
NBDCONF=`expr $NBDCONF`
if [ "$NBDCONF" != "0" ] ; then
	echo Some ppp dialout configs: Enabling module dialout
	linuxconf --setmod dialout
fi
echo Enabling module redhatppp
linuxconf --setmod redhatppp
echo Enabling module modemconf
linuxconf --setmod modemconf
echo Enabling module motd
linuxconf --setmod motd
echo Enabling module firewall
linuxconf --setmod firewall
echo Enabling module status
linuxconf --setmod status
echo Enabling treemenu module
linuxconf --setmod treemenu
echo Enabling module inittab
linuxconf --setmod inittab
echo Enabling module managerpm
linuxconf --setmod managerpm

