/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_INDEX_H
#define GNOME_APT_INDEX_H

#include "gnome-apt.h"
#include "cache.h"
#include "filter.h"
#include "pkgtree.h"

#include <vector>
#include <set>

class Indexes;

class Index :  public GAptCacheFile::CacheView,
               public Filter::View
{
public:
  Index(Indexes* indexes, GAptPkgTree* tree, Filter* filter);
  virtual ~Index();

  void add(pkgCache::Package* package);
  void add(vector<pkgCache::Package*> & packages);

  void remove(pkgCache::Package* package);

  // View interfaces

  void set_cache(GAptCache* cache);

  void filter_changed();

private:
  Indexes* indexes_;
  GAptPkgTree* tree_;
  GAptCache* cache_;
  Filter* filter_;
  vector<pkgCache::Package*> packages_;

  GtkWidget* dialog_;
  GtkWidget* clist_;

  // used to restore the index after 
  //  a cache change
  vector<string> package_names_;

  void add_to_clist(pkgCache::Package* package);
  void remove_from_clist(pkgCache::Package* package);

  void refill();

  static gint dialog_close(GtkWidget* d, gpointer data);
  void detach_dialog();
};

// Manager for all the indexes
// Eventually we will probably have an indexes menu
//  on the view menu, allowing show/hide/delete on 
//  each index.

class Indexes {
public:
  Indexes();
  ~Indexes();

  void add(Index* i);

  // Avoid "delete this" so an Index can cause its own death
  void schedule_for_deletion(Index* i);

private:
  set<Index*> indexes_;
  vector<Index*> to_be_deleted_;
  
  static gint deletion_idle(gpointer data);
  void do_deletion();
  bool deletion_pending_;
  guint idle_tag_;
};

Indexes* gnome_apt_indexes();
void     gnome_apt_indexes_shutdown();

#endif
