/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "details.h"


static gint
delete_event_handler(GtkWidget* window,
                     GdkEvent* event,
                     gpointer data)
{
  Details* d = static_cast<Details*>(data);
  
  d->hide();

  return TRUE; // prevent destroy
}

Details::Details()
{
  window_ = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_window_set_title(GTK_WINDOW(window_), _("Package Details"));

  gtk_container_add(GTK_CONTAINER(window_),
                    info_.widget());

  gtk_signal_connect(GTK_OBJECT(window_),
                     "delete_event",
                     GTK_SIGNAL_FUNC(delete_event_handler),
                     this);

  gtk_container_set_border_width(GTK_CONTAINER(info_.widget()),
                                 GNOME_PAD_SMALL);

  gtk_widget_show_all(info_.widget());
}

Details::~Details()
{
  if (window_) gtk_widget_destroy(window_);
}
  
void 
Details::show()
{
  if (!GTK_WIDGET_VISIBLE(window_))
    gtk_widget_show(window_);
  else 
    {
      gdk_window_show(window_->window);
      gdk_window_raise(window_->window);
    }
}

void 
Details::hide()
{
  gtk_widget_hide(window_);
}


