
#ifndef _PACKAGE_LIST_H
#define _PACKAGE_LIST_H

#include "filters.h"

class FilterList;

class PackageList
{ public:
	struct Package;

	enum ListType
	{ Empty = 0, AllPkgs = 1, ModPkgs = 2 };

      protected:
	 Package * _Head;
	Package *_Tail;

	ListType Type;

	long PackageCount;

	/*
	 * Filtering
	 * -----------------------------------------------------
	 * Is this package list filtered, if so, in what way?
	 * Constructor uses this to construct the linked list.
	 */
	 FilterList::FilterMode FilteredMode;

      public:
	enum pkgFlags
	{ None = 0, Expanded = (1 << 0), Matched = (1 << 1) };
	enum pkgType
	{ Pkg, Div_Sect, Div_Pri, Div_State, Div_Custom };

	// Methods to inject packages into the list (ListType)
	void reinitialize(void);
	void inject_all_packages(void);
	void inject_changed_packages(void);
	void free_list(void);

	// List modification functions
	Package *add(Package * carbon = NULL);
	Package *append(Package *);
	void remove(Package *);

	// Locate functions
	Package *LocateNext(bool start_at_beginning = false);
	Package *LocateFirst(void)
	{
		return LocateNext(true);
	};
	void Locate(char *, unsigned long);

	// Flag typing functions
	void AddFlag(Package *, pkgFlags);
	void AddFlag(pkgFlags);
	void ClearFlag(Package *, pkgFlags);
	void ClearFlag(pkgFlags);
	int CountFlag(pkgFlags);
	void SetType(Package *, pkgType);
	inline ListType GetType()
	{
		return Type;
	};
	inline FilterList::FilterMode GetFilterMode()
	{
		return FilteredMode;
	};

	// Common comparison functions
	bool IsDivider(Package *);
	bool IsMatched(Package *);
	bool IsExpanded(Package *);

	// Size operators
	inline long Length()
	{
		return PackageCount;
	};

	// Pointer accessors
	inline Package *Head()
	{
		return _Head;
	};

	 PackageList(ListType Init = AllPkgs);
	 PackageList(FilterList::FilterMode NewMode, ListType Init = AllPkgs);
	~PackageList();
};

struct PackageList::Package
{
	pkgCache::PkgIterator pkg;

	PackageList::pkgType type;	// Type of this package [line ?]
	PackageList::pkgFlags flags;	// Flags associated with this package

	int increment;		// How far this pkg increments in dependency

	void *Extra;		// A pointer for other uses ...

	struct PackageList::Package * next;
	struct PackageList::Package * prev;
	struct PackageList::Package * p_parent;
};

#endif
