
#include <std.h>

#include <interface/coreui.h>
#include <interface/acquire.h>
#include <interface/formatting.h>
#include <interface/dialogs.h>

#include <list/colors.h>

#include "init_status.h"

InitStatus::InitStatus(Configuration & Config):NoUpdate(false), NoDisplay(false)
{
	if (Config.FindI("quiet", 0) >= 1)
		NoUpdate = true;
	if (Config.FindI("quiet", 0) >= 2)
		NoDisplay = true;

	InitWindows();
};


InitStatus::~InitStatus()
{
	Done();
	EndWindows();
}

void InitStatus::Done()
{
	if (NoUpdate == false)
		if (_error->PendingError() == true)
			ui_dialog(Pair(COLOR_RED, COLOR_BLUE) | A_BOLD, "Error", (char *) Op.c_str());
}

void InitStatus::Update()
{
	if (CheckChange() == false)
		return;

	// No percent spinner
	if (NoUpdate == true)
		return;

	// Print the spinner

	float pbarlen = (Percent / 100) * (COLS / 1.7);

	werase(wInitProgress);

	wattrset(wInitProgress, Pair(COLOR_GREEN, COLOR_BLUE) | A_BOLD);
	mvwprintw(wInitProgress, 0, ((int) (COLS / 1.7) - Op.length()) / 2, (char *) Op.c_str());
	wattrset(wInitProgress, Pair(COLOR_YELLOW, COLOR_BLUE) | A_BOLD);
	mvwprintw(wInitProgress, 1, ((int) (COLS / 1.7) - SubOp.length()) / 2, (char *) SubOp.c_str());

	wattrset(wInitProgress, Pair(COLOR_BLACK, COLOR_WHITE));

	for (int I = 0; I < (COLS / 1.7); I++)
		mvwaddch(wInitProgress, 2, I, ' ');

	wattrset(wInitProgress, Pair(COLOR_WHITE, COLOR_RED));

	for (int I = 0; I < pbarlen; I++)
		mvwaddch(wInitProgress, 2, I, ' ');

	wrefresh(wInitProgress);
}

void InitStatus::InitWindows()
{
	int y_len = 3;		// One line total
	int y_start = (LINES - y_len) / 2;	// Centered
	int x_len = (int) (COLS / 1.7);	// Full length of screen
	int x_start = (COLS - x_len) / 2;	// Centered

	noecho();
	cbreak();
	wInitProgress = newwin(y_len, x_len, y_start, x_start);
	scrollok(wInitProgress, false);
	wattrset(wInitProgress, Pair(COLOR_GREEN, COLOR_BLUE) | A_BOLD);
	wbkgd(wInitProgress, Pair(COLOR_GREEN, COLOR_BLUE) | A_BOLD);
	wrefresh(wInitProgress);

	curs_set(0);
}

void InitStatus::EndWindows()
{
	delwin(wInitProgress);
	refresh();
}
