
#ifndef _misc_H
#define _misc_H

#define SEARCH_CASE   0x1
#define SEARCH_DESC   0x2
#define SEARCH_REGEX  0x4

#define bitcheck(x, y)        (x & y)
#define bitset(x, y)          (x |= y)
#define bitclear(x, y)        (x &= ~y)

#include <regex.h>

namespace TextOp
{
	enum opType
	{ none, upgrade, update, install, remove, purge };
	extern bool CacheInit;
	extern bool BrokenFix;
	extern unsigned opRealCount;

	void PrepareOp(opType, string);
	void Install(string);
	void Remove(string, bool);
};

#include <func/keys.h>

void HelpDialog();
int search_string(const char *, char *, unsigned long, regex_t *);

#endif /* _misc_H */
