
#include <std.h>

#include <func/apt.h>

#include <interface/dialogs.h>

// TryToInstall - Try to install or remove a single package
// ---------------------------------------------------------------------
bool TryToInstall(pkgCache::PkgIterator Pkg, pkgDepCache & Cache, pkgProblemResolver & Fix, bool Remove, bool BrokenFix, unsigned int &ExpectedInst, bool AllowFail = true)
{
	string s;

	/* This is a pure virtual package and there is a single available 
	   provides */
	if (Cache[Pkg].CandidateVer == 0 && Pkg->ProvidesList != 0 && Pkg.ProvidesList()->NextProvides == 0)
	{
		pkgCache::PkgIterator Tmp = Pkg.ProvidesList().OwnerPkg();
		ui_dialog(0, "\n Missed selection", "Note, selecting %s instead of %s \n", Tmp.Name(), Pkg.Name());
		Pkg = Tmp;
	}

	// Handle the no-upgrade case
	/*if (_config->FindB("APT::Get::no-upgrade", false) == true && Pkg->CurrentVer != 0)
	   {
	   if (AllowFail == true)
	   c1out << "Skipping " << Pkg.Name() << ", it is already installed and no-upgrade is set." << endl;
	   return true;
	   } */

	// Check if there is something at all to install
	pkgDepCache::StateCache & State = Cache[Pkg];
	if (Remove == true && Pkg->CurrentVer == 0)
	{
		if (AllowFail == false)
			return false;

		ui_dialog(0, "Not installed", "\n Package %s is not installed \n", Pkg.Name());

		return false;
	}

	if (State.CandidateVer == 0 && Remove == false)
	{
		if (AllowFail == false)
			return false;

		if (Pkg->ProvidesList != 0)
		{
			s = "\n Package " + string(Pkg.Name()) + " is a virtual package provided by: \n";

			pkgCache::PrvIterator I = Pkg.ProvidesList();
			for (; I.end() == false; I++)
			{
				pkgCache::PkgIterator Pkg = I.OwnerPkg();

				if (Cache[Pkg].CandidateVerIter(Cache) == I.OwnerVer())
				{
					if (Cache[Pkg].Install() == true && Cache[Pkg].NewInstall() == false)
						s += "  * " + string(Pkg.Name()) + " " + string(I.OwnerVer().VerStr()) + " [Installed]\n";
					else
						s += "  * " + string(Pkg.Name()) + " " + string(I.OwnerVer().VerStr()) + "\n";
				}
			}
			s += " You should explicitly select one to install.\n";
		}
		else
		{
			s = "\n Package $2#" + string(Pkg.Name()) + "$! has no available version, but exists in the database. \n"
				" This typically means that the package was mentioned in a dependency and \n"
				" never uploaded, has been obsoleted or is not available with the contents \n" " of sources.list";

			pkgCache::DepIterator Dep = Pkg.RevDependsList();

			string t;

			for (; Dep.end() == false; Dep++)
			{
				if (Dep->Type != pkgCache::Dep::Replaces)
					continue;
				t += " * " + string(Dep.ParentPkg().Name()) + "\n";
			}

			if (t.length() > 0)
				s += ", however the following package(s) replace it: \n\n" + t;
			else
				s += ".\n";
		}

		ui_dialog(0, (char *) (string(Pkg.Name()) + " has no version").c_str(), "%s", s.c_str());

		_error->Error("Package %s has no installation candidate", Pkg.Name());

		return false;
	}

	Fix.Clear(Pkg);
	Fix.Protect(Pkg);
	if (Remove == true)
	{
		Fix.Remove(Pkg);
		Cache.MarkDelete(Pkg, _config->FindB("APT::Console::Purge", false));
		ExpectedInst++;
		return true;
	}

	// Install it
	Cache.MarkInstall(Pkg, false);
	if (State.Install() == false)
	{
		if (_config->FindB("APT::Console::ReInstall", false) == true)
		{
			if (Pkg->CurrentVer == 0 || Pkg.CurrentVer().Downloadable() == false)
				ui_dialog(0, "Reinstall impossible", "\n Sorry, %s cannot be downloaded \n", Pkg.Name());
			else
				Cache.SetReInstall(Pkg, true);
		}
		else
		{
			if (AllowFail == true)
				ui_dialog(0, "Package already upgraded",
					  "\n Sorry, package is already the newest version: \n\n '%s' [= $2#%s$!] \n", Pkg.Name(), Cache[Pkg].InstVerIter(Cache).VerStr());
		}
	}
	else
		ExpectedInst++;

	// Install it with autoinstalling enabled.
	if (State.InstBroken() == true && BrokenFix == true)
		Cache.MarkInstall(Pkg, true);
	return true;
}
