/*
 * losetup.c - setup and control loop devices
 */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>
#include <time.h>
#include <utime.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "dbootstrap.h"

/* jump through hoops to be _sure_ we get the right
 * dev_t to make the loop device happy...  */
/*
#include <linux/loop.h>
*/
#include <linux/posix_types.h>
#undef dev_t
#define dev_t __kernel_dev_t
#include <linux/loop.h>
#undef dev_t



/* Loop device setup stuff, swiped from busybox. */

int del_loop(const char *device)
{
    int fd;

    if ((fd = open(device, O_RDONLY)) < 0) {
	perror(device);
	return( FALSE);
    }
    if (ioctl(fd, LOOP_CLR_FD, 0) < 0) {
	perror("ioctl: LOOP_CLR_FD");
	return( FALSE);
    }
    close(fd);
    return( TRUE);
}

int set_loop(const char *device, const char *file, int offset, int *loopro)
{
	struct loop_info loopinfo;
	int	fd, ffd, mode;
	
	mode = *loopro ? O_RDONLY : O_RDWR;
	if ((ffd = open (file, mode)) < 0 && !*loopro
	    && (errno != EROFS || (ffd = open (file, mode = O_RDONLY)) < 0)) {
	  perror (file);
	  return 1;
	}
	if ((fd = open (device, mode)) < 0) {
	  close(ffd);
	  perror (device);
	  return 1;
	}
	*loopro = (mode == O_RDONLY);

	memset(&loopinfo, 0, sizeof(loopinfo));
	strncpy(loopinfo.lo_name, file, LO_NAME_SIZE);
	loopinfo.lo_name[LO_NAME_SIZE-1] = 0;

	loopinfo.lo_offset = offset;

	loopinfo.lo_encrypt_key_size = 0;
	if (ioctl(fd, LOOP_SET_FD, ffd) < 0) {
		perror("ioctl: LOOP_SET_FD");
		close(fd);
		close(ffd);
		return 1;
	}
	if (ioctl(fd, LOOP_SET_STATUS, &loopinfo) < 0) {
		(void) ioctl(fd, LOOP_CLR_FD, 0);
		perror("ioctl: LOOP_SET_STATUS");
		close(fd);
		close(ffd);
		return 1;
	}
	close(fd);
	close(ffd);
	return 0;
}

char *find_unused_loop_device (void)
{
	char dev[20];
	int i, fd;
	struct stat statbuf;
	struct loop_info loopinfo;

	for(i = 0; i <= 7; i++) {
	    sprintf(dev, "/dev/loop%d", i);
	    if (stat (dev, &statbuf) == 0 && S_ISBLK(statbuf.st_mode)) {
		if ((fd = open (dev, O_RDONLY)) >= 0) {
		    if(ioctl (fd, LOOP_GET_STATUS, &loopinfo) == -1) {
			if (errno == ENXIO) { /* probably free */
			    close (fd);
			    return strdup(dev);
			}
		    }
		    close (fd);
		}
	    }
	}
        return NULL;
}

/* END CODE */
