try:
    try:
        # xml interface (DOM-2, SAX-2) as found in PyXML 0.6.2
        from xml.dom.ext.reader.Sax2 import Reader

        def _get_dom (filename):
            return Reader (validate = 1).fromStream (open(filename))
    except ImportError:
        # xml interface (DOM-2, SAX-2) as found in PyXML 0.6.1
        from xml.dom.ext.reader.Sax2 import FromXmlFile

        def _get_dom(filename):
            return FromXmlFile(filename, validate=1)

    from xml.dom.Node import Node

    def get_dom(filename):
        # change dir to find DTD file
        dom = _get_dom(filename)
        return dom

    def get_attr(attrs, name):
        if attrs.has_key(('', name)):
            return attrs[('', name)]._get_value()

    def get_dom_attrs(dom):
        return dom.documentElement._get_attributes()

    def get_node_attrs(node):
        return node._get_attributes()

    def get_node_name(node):
        return node._get_nodeName()

    def get_childnodes(node):
        return node._get_childNodes()

    def node_value(node):
        if node._get_nodeType() == Node.TEXT_NODE:
            return node._get_nodeValue()
        s = ""
        for n in node._get_childNodes():
            s = s + node_value(n)
        return s

    def filter_by_name (element, name):
        result = []

        # print 'filter_by_name:', element

        for elem in element.childNodes:
            if elem.nodeType == Node.ELEMENT_NODE and elem.tagName == name:
                result.append (elem)

        # print 'filter_by_name:', result

        return result

except ImportError:
    # xml interface (DOM-1, SAX-1) as found in PyXML 0.5.x
    from xml.sax import saxexts,saxutils
    from xml.dom.sax_builder import SaxBuilder
    from xml.dom.core import TEXT_NODE, ELEMENT_NODE

    _parser = saxexts.XMLValParserFactory.make_parser()
    _parser.setErrorHandler(saxutils.ErrorPrinter())
    def get_dom(filename):
        _dom_builder = SaxBuilder()
        _parser.setDocumentHandler(_dom_builder)
        _parser.parse(filename)
        _parser.reset()
        return _dom_builder.document
    def get_attr(attrs, name):
        if attrs.has_key(name):
            return attrs[name].get_value()
    def get_dom_attrs(dom):
        return dom.get_documentElement().get_attributes()
    def get_node_attrs(node):
        return node.get_attributes()
    def get_node_name(node):
        return node.get_name()
    def get_childnodes(node):
        return node.get_childNodes()
    def node_value(node):
        if node.get_nodeType() == TEXT_NODE:
            return node.get_nodeValue()
        s = ""
        for n in node.get_childNodes():
            s = s + node_value(n)
        return s

    def filter_by_name (element, name):
        result = []

        # print 'filter_by_name:', element

        for elem in element.childNodes:
            if elem.get_nodeType () == ELEMENT_NODE and get_node_name (elem) == name:
                result.append (elem)

        return result

def get_node_attr (node, name):
    return get_attr (get_node_attrs(node), name)
