#!/bin/bash
#
# Bruce Perens, July-September 1995
# Enrique Zanardi, January 1998
#
# This is free software under the GNU General Public License.

. ./common.sh

# Print a usage message and exit if the argument count is wrong.
if [ $# -ne 4 ]; then
echo "Usage: $0 revision-extension modules-archive modcont-file modconf-debfile" 1>&2
	cat 1>&2 << EOF

	revision-extension: the revision extension of the kernel.
	modules-archive: tgz containing the modules
	modcont-file: text file containing the list of modules in each subdir
		(generated by kernel.sh)
	archive: the directory containing the Debian binary packages.

EOF

	exit -1
fi

revext="$1"

modules=$2

modcont=$3

archive=$4

# If we're not root, bad things happen (modules owned by wrong user)
testroot

# Make sure the required files are there.
if [ ! -f $modules ]; then
	error "can't find $modules"
fi
if [ ! -f $modcont ]; then
	error "can't find $modcont"
fi
if [ ! -d $archive ]; then
	error "Can't find $archive"
fi

# where we construct the disk breaking up
tartmp=${tmpdir}/boot-floppies/drivers-$$
rm -f -r $tartmp
make_tmpdir $tartmp

# temporary directory
E=${tmpdir}/boot-floppies/extract-tmp-$$

exit=false

PACKAGE_PATH=`make_paths modconf modutils whiptail`

if [ "$arch" = i386 -o "$revext" = pmac ]; then
	PACKAGE_PATH="$PACKAGE_PATH `make_paths pcmcia-cs`"
fi

if $exit; then
	exit -1
fi

if [ -d $E ]; then
	info "removing old driver temporary area ($E)"
	mv -f $E $E.old
	rm -fr $E.old
fi

make_tmpdir $E

info "extracting into driver staging area $E"
for i in $PACKAGE_PATH; do
	debug extracting $i
	dpkg-deb --extract $i $E
done

if [ "$arch" = i386 -o "$revext" = pmac ]; then
	info "tarring pcmcia materials into staging area $tartmp"
	(cd $E && tar -cf pcmcia.tar \
		etc/apm/event.d/pcmcia \
		etc/init.d/pcmcia \
		etc/pcmcia \
		sbin/ifport \
		sbin/ifuser \
		sbin/cardmgr)
	gzip -9f $E/pcmcia.tar
	cp $E/pcmcia.tar.gz $tartmp/pcmcia.tgz
fi


info "moving from temporary area into $tartmp"
(cd $E && tar -cf modconf.tar \
	usr/bin/whiptail \
	sbin/update-modules \
	etc/modutils \
	usr/sbin/modconf \
	usr/share/modconf)
# FIXME: doesn't deal with tar errors in last cmd
gzip -9f $E/modconf.tar
cp $E/modconf.tar.gz $tartmp/modconf.tgz

cp $modules $tartmp/modules.tgz
cp $modcont $tartmp/modcont

rm -fr $E

info "finishing up $tartmp"
cp scripts/drivers/install.sh $tartmp/install.sh
chmod 777 $tartmp/install.sh
echo drivers > $tartmp/type.txt

outfile=drivers${revext}.tgz
info "moving $tartmp into $outfile"
(cd $tartmp; tar clf - .) | gzip --best > $outfile
rm -fr $tartmp

info "splitting drivers into floppy-sized chunks"
case $arch in
    i386)
	if [ -z "$revext" ] ; then
		./utilities/floppy_split $outfile drv12$revext 1200
		pad_last_image drv12$revext 1200
	fi
	./utilities/floppy_split $outfile drv14$revext 1440
	pad_last_image drv14$revext 1440
	;;
    m68k)
	./utilities/floppy_split $outfile drv14$revext 1440
	pad_last_image drv14$revext 1440
	;;
    powerpc)
	./utilities/floppy_split $outfile drv14$revext 1440
	pad_last_image drv14$revext 1440
	;;
    *)
	./utilities/floppy_split $outfile drv14$revext 1440
	pad_last_image drv14$revext 1440
	;;
esac

exit 0
