dnl README-Users.m4 - Will become top-level README in disks-<arch>.
dnl
dnl Use [] for quotes so that in the emacsen, `forward-sexp' and
dnl `backward-sexp' along with paren highlighting will help find nesting
dnl errors.
dnl
changequote([,])dnl
dnl
dnl Most platforms have sub-architectures, define them here.
dnl
dnl FIXME: This should be defined in the top-level Makefile
dnl        and passed in by way of `release.sh', which is where
dnl        this file gets run through `m4'.
dnl
ifelse(ARCHITECTURE, sparc,   [define(SUBARCHES, [sun4cdm, sun4u, sun4dm-pci])],
       ARCHITECTURE, m68k,    [define(SUBARCHES, [amiga, atari, mac, mvme16x, bvme6000])],
       ARCHITECTURE, powerpc, [define(SUBARCHES, [chrp, powermac, prep])],
       ARCHITECTURE, alpha,   [define(SUBARCHES, [jensen, nautilus])])[]dnl
dnl
dnl A few platforms have flavors, define them here.
dnl
dnl FIXME: Perhaps this should be defined in the top-level Makefile (?)
dnl
dnl If you need to add to this list, please see to it that it will be
dnl formatted nicely where it is expanded below by putting a line break
dnl and a 6 space indent in the right place inside the definition of
dnl FLAVORS.
dnl
dnl For that reason, it might not be the right thing to define this from
dnl the Makefile.
dnl
ifelse(ARCHITECTURE, i386, [define(FLAVORS, [`compact', 'idepci',
      and `udma66'])])[]dnl
dnl
dnl Some, but not all, platforms have several sizes of diskette images.
dnl
ifelse(ARCHITECTURE, i386,    [define(SIZES,t)],
       ARCHITECTURE, sparc,   [undefine(SIZES)],
       ARCHITECTURE, m68k,    [define(SIZES,t)],
       ARCHITECTURE, powerpc, [undefine(SIZES)],
       ARCHITECTURE, alpha,   [undefine(SIZES)])[]dnl
dnl
dnl
dnl See the comment in "utilities/dbootstrap/main.c:setup_image_names()"
dnl for information about the directory layout expected by `dbootstrap'.
dnl
dnl          <debian>/${subarch}${images_size}${flavor}
dnl

		    The Debian Installation System
                    ==============================

			  Quick Orientation


  The Debian Installation system can be found at the following location
  on any Debian archive:

    <debian>/dists/potato/main/disks-ARCHITECTURE/current/

  The word `<debian>' may indicate an FTP area, Web distribution area,
  or official Debian CD-ROM.  All the files required for installation
  can be found under this directory.

  Full information on how to install Debian can be found in the
  documentation located under the `doc' subdirectory.  Documentation
  is available in several formats and languages.  Bookmark and read
  <URL:http://www.debian.org/releases/stable/> for errata, security
  alerts, and other updated information.

  Even though the Debian Installation System is also called the
  `boot-floppies', it is possible (in fact, desirable) to use the
  system to install without the use of floppies at all.  For instance,
  you may be able to install Debian from bootable CD-ROM, from the
  network, or from another operating system.  The name `boot-floppies'
  is something of a historical artifact.  See the documentation for
  complete information.


  ** Layout Of The Installation Files

  The general organization of files in this directory is described
  below.  If you are copying a subset of these files to local disk or
  what have you, you should retain the internal directory structure,
  since the installation system will be looking for files in these
  locations.

  doc/

      The Debian GNU/Linux Installation Manual, the Beginner's Guide for
      `dselect', and the Release Notes may be found here in several
      computer readable and printable formats.  Please, Read The Fine
      Manual (RTFM) before you begin!
dnl
ifdef([SUBARCHES], [dnl

  <subarch>/

      Installation files for a subdivision of the ARCHITECTURE architecture;
      you will need to look under here to find your boot, root, and
      drivers disks.  This architecture has the following <subarch>'s:

           SUBARCHES
dnl
ifelse(ARCHITECTURE, sparc, [dnl

     sun4cdm .... This is used for most non-Ultra systems. This includes
                  SPARCStation 1, 2, ELC, IPC, IPX, 5, 10, 20 as well as
                  SPARC Classics.

     sun4dm-pci . Same as the above kernel but with PCI support for use
                  with systems that have a PCI bus and/or ps2 mouse and
		  keyboard

     sun4u ...... This includes the entire UltraSPARC class of systems,
                  including IDE systems such as UltraSPARC 5. Only the
                  rescue and drivers are different from sun4cdm. The root
                  and base image is the same.

],dnl
ARCHITECTURE, alpha, [dnl

      In general, on Alpha, you should use the generic rescue and
      drivers images, which reside in the top-level images-1.44
      directory.  If you boot from CD, these will be used by default.

      When booting from floppy on the SRM console (we recommend you
      use SRM for new installs - see the installation manual), you
      should always use these (except on the 'jensen'
      subarchitecture).  To boot from the rescue floppy disk from the
      SRM console, type `boot dva0 -fl 0' at the SRM console prompt.

      If you are booting from a floppy using MILO, you will also need
      to create a MILO disk from MILO and LINLOAD.EXE images, as
      detailed below.

      The Nautilus platform (the UP1000 motherboard) uses APB.  On
      these systems, power up the Alpha, insert the Nautilus rescue
      disk, and enter `apb.exe' as the Boot File in the AlphaBIOS `OS
      Selection Setup' menu, or run `apb.exe' from the `Utility/Run
      Maintenance Program' menu.  Then, at the APB prompt, type `boot
      debian_install'.

  MILO/

      Contains MILO boot loaders for certain platforms.  These are used
      for booting on ARC and AlphaBIOS systems.

      To boot on one of these from CD, find your subarchitecture from
      the table in the documentation, then enter `\milo\linload.exe'
      as the boot loader and `\milo\<subarch>' (where <subarch> is the
      proper subarchitecture name) as the OS Path in the `OS Selection
      Setup' menu.

      To boot one of these from floppy, copy the file with the same
      name as your subarchitecture (this is the MILO binary) and
      `linload.exe' from this directory to a DOS-formatted floppy
      disk.  Power on your Alpha, insert this disk, then enter the `OS
      Selection Setup' menu in ARC or AlphaBIOS.  Set the boot device
      to the floppy drive, the OS Loader to `\linload.exe', and the OS
      Path to your subarchitecture name (i.e. the name of the MILO
      binary).  Then, at the MILO prompt, insert the rescue disk and
      enter the command `boot fd0:'.

  APB/

      Contains the APB boot loader and associated files for the UP1000
      motherboard.  These are used when booting from CD on the UP1000.
      To boot on this platform, run '\apb\apb.exe' from the
      `Utility/Run Maintenance Program' menu, and type `boot
      debian_install' at the APB prompt.
]dnl,
dnl ARCHITECTURE, XXX, [
dnl This probably ought to be filled in more by the maintainers who know
dnl what to say here for their architecture's subarch's.
dnl]
)[]dnl ifelse(ARCHITECTURE, ...)
])[]dnl ifdef([SUBARCHES], ...)
dnl
ifdef([FLAVORS], [dnl

  ifdef([SUBARCHES],[<subarch>/])<flavor>/

      There are several `flavors' of installation disk available.  In
      some cases the images contain a Linux kernel compiled with
      certain options that make it work better on some hardware.  See
      below for information about why you might need to use a flavor.

      Also in this directory are files for a particular flavor which
      are not disk images, but may be helpful for network
      installations or installations from another operating system.

      During a network, NFS, or CD-ROM install, the install software
      knows how to find these files, once you have indicated the
      <debian> directory.  If you plan to copy these files to a spot
      on your hard drive in anticipation of using the installer's
      "from a mounted partition" option, you do not need to duplicate
      the directory structure of the <debian> archive, but you do need
      to make sure you get a matched set of images, all of the same
      <flavor>, or things probably won't work correctly.

      The flavors available for this architecture are FLAVORS.
dnl
ifelse(ARCHITECTURE, i386, [dnl

      compact .... A Linux kernel with some non-critical device
                   drivers removed, and a few of the more common PCI
                   device drivers compiled into the kernel itself.
                   See images-1.44/compact/README.txt

      idepci ....  Similar to compact, but even more PCI device drivers
                   are compiled into the kernel, and SCSI is removed.
                   See images-1.44/idepci/README.txt

      udma66 ..... Specialized kernel for those who require the UDMA66
                   IDE patch.  This may be needed if you have a
                   Promise Ultra66 IDE controller, among others.
                   See images-1.44/udma66/README.txt
]dnl,
dnl ARCHITECTURE, XXX, [dnl
dnl   Other arch with flavor info goes here.
dnl]
)dnl
])[]dnl
dnl
ifdef([SIZES], [dnl

  ifdef([SUBARCHES],[<subarch>/])images-<size>/ifdef([FLAVORS],[<flavor>/])

      Disk images of size <size>.  Choose the size that will fit on the
      media you intend to bootstrap the installation software from, and
      follow the instructions below under "Writing Image Files to
      Floppies".
])[]dnl


  ** Specific Files of Interest

  Using the descriptions above, you need to select the directory
  containing the set of files which is appropriate to the installation
  you are doing.  You will need all of the following `.bin' images,
  unless marked otherwise.

  .../rescue.bin

      Rescue disk image, containing the kernel and a boot loader.

  .../root.bin

      Root disk image, containing the root file system.  Not required
      unless are you are installing from floppies.

  .../driver-#.bin

      Device driver disk images, containing kernel modules you can
      load for hardware for which there is not a driver built into the
      kernel.  For instance, you can use this to install a driver for
      your network adapter; once you have installed that driver, you
      can install the rest of the system over the network.  Other
      modules include PPP, parallel support, etc.  Not required unless
      are you are installing from floppies.

  .../drivers.tgz

      A compressed tar archive containing the same modules as the
      above disk images.  These are used when installation kernel and
      drivers from local disk or CD rather than from floppies.  Use
      the file from the appropriate subdirectory based on what
      ifdef([SUBARCHES],subarchitecture)ifdef([FLAVORS],flavor) you are using, if any.

  .../base-#.bin

      The base Debian distribution (BASE_TGZ), split into disk images.
      If you intend to install from the network, NFS, a mounted
      partition, or a CD-ROM, you will not need the `base-#.bin'
      images.  (This is good news for the majority of us.)  These are
      for floppy-only installs, or people installing the base system
      so that they can get PPP started and the rest of their system
      installed via modem.  Not required unless are you are installing
      from floppies.
dnl
ifelse(ARCHITECTURE, sparc, [dnl

  .../tftpboot.img

      Subarch specific TFTP bootable images.  These images contain the
      kernel and root.bin for booting completely from a TFTP server using
      the PROM "boot net" command.  See docs for details.

  root.tar.gz

      An NFS mountable root tarball.  This is exactly the same as the
      root.bin, but in a tar format so as to be extracted on a net
      server for installing systems via an NFS root.  See docs for
      details.

],dnl
ARCHITECTURE, alpha, [dnl

  .../linload.exe

      ARC console executable that is needed to load MILO

  .../apb.exe

      Alpha Processor Bootloader, an ARC console executable that is
      used to boot Linux on the UP1000 motherboard from Alpha
      Processor, Inc.

  .../up1000.pal

      PALCode (Privileged Architecture Library code) for the UP1000
      motherboard.

  tftpboot.img

      TFTP bootable image. This image contains the kernel and root.bin
      for booting completely from a TFTP server using the SRM console.
      See the installation manual for full details.

  root.tar.gz

      An NFS mountable root tarball.  This is exactly the same as the
      root.bin, but in a tar format so as to be extracted on a net
      server for installing systems via an NFS root.  See docs for
      details.

])[]dnl

  BASE_TGZ

      The Debian base system in a compressed tar archive, used for the
      network, NFS, mounted file system, and CD-ROM installation
      methods.  This contains a complete minimalist Debian GNU/Linux
      installation, as well as everything required to begin installing
      everything else you want.
dnl
ifdef([ADDONS_TGZ], [dnl

  ADDONS_TGZ

      A compressed tar archive containing additional cruft being foisted
      upon you by the folks who made this CD-ROM.  It might be just
      about any kind of cruft you can imagine some breakaway up-start
      thinks makes his CDs better than the official Debian version.
])[]dnl

  ifelse(ARCHITECTURE, i386, basecont, base-contents).txt

      List of packages in the base distribution, and their version
      numbers.
dnl
ifelse(ARCHITECTURE, i386, [dnl

  .../install.bat

      DOS batch script for booting into the installation system from
      DOS.  A different version of this batch file is available for
      each flavor.

  .../linux

      A Linux kernel image, used by the batch script above.


])[]dnl


  ** Writing Image Files to Floppies

  You can write the *.bin disk images to floppies with dd.  Replace
  `<file>' with the name of the image file in the following command:

    dd of=/dev/fd0 if=<file> bs=1024

  If you are naturally suspicious, you can make sure the image was
  successfully written:

    cmp /dev/fd0 <file>

ifelse(ARCHITECTURE, i386, [dnl
  Alternatively, from DOS, you can use use rawrite2.exe to write the
  files to floppies:

    rawrite2 -f <file> -d a

])dnl
dnl
dnl Local Variables:
dnl compile-command: "m4 --define=BASE_TGZ=base2_2.tgz --define=ARCHITECTURE=i386 README-Users.m4"
dnl End:
dnl LocalWords:  sparc SUBARCHES cdm amiga atari mac mvme bvme powerpc chrp sh
dnl LocalWords:  powermac alcor avanti idepci udma undefine dbootstrap debian doc
dnl LocalWords:  subarch dselect RTFM ifdef SPARCStation ELC IPC IPX UltraSPARC
dnl LocalWords:  IDE SRM jensen subarchitecture dva fl MILO LINLOAD APB apb milo
dnl LocalWords:  AlphaBIOS linload fd XXX subarch's installer's PCI PPP TGZ TFTP
dnl LocalWords:  PROM Bootloader PALCode tftpboot img ADDONS CDs basecont txt
dnl LocalWords:  linux dd bs cmp tgz dnl emacsen sexp paren changequote FIXME
  # LocalWords:  ifelse dm pci ps EXE exe docs tarball rawrite
