// vs_statusedit.cc
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Code to edit a string in the status line.

#include "vs_statusedit.h"
#include "config/keybindings.h"

bool vs_statusedit::dispatch_char(chtype ch)
{
  int x,y;
  if(global_bindings.key_matches(ch, "EditDelBack"))
    {
      if(text.size()>0)
	{
	  text.erase(text.size()-1);
	  get_tree()->show_status();
	  get_tree()->getmaxyx(y,x);
	  get_tree()->move(y, prompt.size()+text.size());
	  get_owner()->refresh();
	}
      else
	{
	  beep();
	  get_owner()->refresh();
	}
      return true;
    }
  else if(global_bindings.key_matches(ch, "EditDone"))
    {
      get_tree()->delete_status_widget(this);
      get_owner()->leaveok(true);
      entered(text);
      return true;
    }
  else if(ch>255)
    {
      beep();
      get_owner()->refresh();
      return true;
    }
  else
    {
      text+=(char) ch;
      get_tree()->show_status();
      get_tree()->getmaxyx(y,x);
      get_tree()->move(y, prompt.size()+text.size());
      get_owner()->refresh();
      return true;
    }
}

void vs_statusedit::display()
{
  int x,y;
  get_owner()->display_status(prompt+text, COLOR_PAIR(get_tree()->get_status_color())|A_BOLD);
  get_owner()->getmaxyx(y,x);
  get_owner()->move(y,prompt.size()+text.size());
}
