// pkg_ver_item.h (This is -*-c++-*-)
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Let you create tree nodes which refer to a particular version of a package.

#ifndef PKG_VER_ITEM_H
#define PKG_VER_ITEM_H

#include "pkg_node.h"
#include "pkg_grouppolicy.h"
#include "pkg_item_with_subtree.h"

#include "vs_tree.h"

#include <apt-pkg/version.h>
#include <apt-pkg/depcache.h>

class pkg_ver_item:public pkg_tree_node
{
  pkgCache::VerIterator version;

  bool show_pkg_name;
public:
  pkg_ver_item(pkgCache::VerIterator _version, bool _show_pkg_name=false):version(_version), show_pkg_name(_show_pkg_name) {}

  pkgCache::VerIterator get_version() const {return version;}

  virtual int get_normal_attr();
  virtual void display(vs_tree *win, int y);

  virtual const char *tag() const;

  virtual void select();
  virtual void hold();
  virtual void remove();
  virtual void purge();

  virtual void highlighted(vs_tree *win);

  bool dispatch_char(chtype ch);
};

class versort:public cmp_policy<pkg_ver_item>
{
  int compare(const pkg_ver_item *item1, const pkg_ver_item *item2)
    {
      return pkgVersionCompare(item1->get_version().VerStr(), item2->get_version().VerStr());
    }
};

typedef pkg_item_with_subtree<pkg_ver_item, versort> pkg_vertree;
class pkg_vertree_generic:public vs_subtree<pkg_ver_item, versort>
{
  string name;
public:
  pkg_vertree_generic(string _name, bool _expanded):vs_subtree<pkg_ver_item, versort>(_expanded),name(_name) {}
  void display(vs_tree *win, int y) {vs_subtree<pkg_ver_item, versort>::display(win, y, name);}
  const char *tag() const {return name.c_str();}
};

// The following policy will make each package given to it into a
// subtree containing all versions of the package known to apt-pkg.
class pkg_grouppolicy_ver_factory:public pkg_grouppolicy_factory
{
public:
  virtual pkg_grouppolicy *instantiate(pkg_subtree *item);
};

// The next class displays the available versions of a single package.
// It takes over the screen when instantiated and returns to the previous
// screen when finished.
class pkg_ver_screen:public vs_tree
{
  vscreen *prev;
public:
  pkg_ver_screen(pkgCache::PkgIterator pkg);

  void dispatch_char(chtype ch);
};

void setup_package_versions(pkgCache::PkgIterator pkg, pkg_vertree *tree);
void setup_package_versions(pkgCache::PkgIterator pkg, pkg_vertree_generic *tree);
// Adds all versions of a package to the given tree.

#endif
