// pkg_node.cc
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Implementations of stuff in pkg_node.h

#include "pkg_node.h"
#include "config/keybindings.h"

bool pkg_tree_node::dispatch_char(chtype ch)
{
  if(global_bindings.key_matches(ch, "SelectPackage"))
    {
      select();
      return true;
    }
  else if(global_bindings.key_matches(ch, "DeselectPackage"))
    {
      remove();
      return true;
    }
  else if(global_bindings.key_matches(ch, "HoldPackage"))
    {
      hold();
      return true;
    }
  else if(global_bindings.key_matches(ch, "PurgePackage"))
    {
      purge();
      return true;
    }
  else return false;
}
