// pkg_item.cc
//
// Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Definitions of stuff in pkg_item.h

#include "pkg_item.h"
#include "pkg_ver_item.h"
#include "dep_item.h"
#include "pkg_description_treeitem.h"
#include "pkg_info_screen.h"

#include "apt.h"

#include <apt-pkg/configuration.h>

void pkg_item::highlighted(vs_tree *win)
{
  pkgCache::VerIterator cand_ver=(*apt_cache_file)[package].CandidateVerIter(*apt_cache_file);

  if(!cand_ver.end())
    win->set_status(apt_package_records->Lookup(cand_ver.FileList()).ShortDesc());
}

void pkg_item::select()
{
  if(!(*apt_cache_file)[package].Delete())
    {
      if((*apt_cache_file)[package].Status==0)
	{
	  (*apt_cache_file)->MarkInstall(package, _config->FindB("Aptitude::Auto-Install", false));
	  if(_config->FindB("Aptitude::Allow-ReInstall", true))
	    (*apt_cache_file)->SetReInstall(package, true);
	}
      else
	(*apt_cache_file)->MarkInstall(package, _config->FindB("Aptitude::Auto-Install", false));
      }
  // EWW!  There's no good way to find out after the fact what was
  // autoselected, so I do this.  Bleah.
  else
    (*apt_cache_file)->MarkKeep(package);
}

void pkg_item::hold()
  // Sets an /explicit/ hold state.  May be useful for, eg, saying that the
  // current package version (which is the newest) should be kept even if/when
  // a newer version becomes available.
{
  if((*apt_cache_file)[package].iFlags&pkgDepCache::ReInstall)
    (*apt_cache_file)->SetReInstall(package,false);
  (*apt_cache_file)->MarkKeep(package);
  (*apt_cache_file)->get_ext_state(package).selection_state=pkgCache::State::Hold;
}

void pkg_item::remove()
{
  if(!(*apt_cache_file)[package].Install() && !((*apt_cache_file)[package].iFlags&pkgDepCache::ReInstall))
    (*apt_cache_file)->MarkDelete(package);
  else
    {
      if((*apt_cache_file)[package].iFlags&pkgDepCache::ReInstall)
	{
	  (*apt_cache_file)->MarkKeep(package);
	  (*apt_cache_file)->SetReInstall(package,false);
	  (*apt_cache_file)->get_ext_state(package).selection_state=pkgCache::State::Install;
	}
      else
	(*apt_cache_file)->MarkKeep(package);
    }
}

void pkg_item::purge()
{
  (*apt_cache_file)->MarkDelete(package, true);
}

int pkg_item::get_normal_attr()
{
  pkgDepCache::StateCache &state=(*apt_cache_file)[package];

 if(state.Status!=2 && (state.Held() || (*apt_cache_file)->get_ext_state(package).selection_state==pkgCache::State::Hold) && !state.NowBroken())
    return COLOR_PAIR(get_color("pkg_to_hold", COLOR_BLACK, COLOR_WHITE));
  else if(state.Delete())
    return COLOR_PAIR(get_color("pkg_to_remove", COLOR_BLACK, COLOR_MAGENTA));
  else if(state.Install() && state.InstBroken())
    return COLOR_PAIR(get_color("pkg_broken", COLOR_BLACK, COLOR_RED));
 else if(state.NewInstall() || (state.iFlags&pkgDepCache::ReInstall))
    return COLOR_PAIR(get_color("pkg_to_install", COLOR_BLACK, COLOR_GREEN));
  else if(state.Upgrade())
    return COLOR_PAIR(get_color("pkg_to_upgrade", COLOR_BLACK, COLOR_CYAN));
  else if(package.CurrentVer().end())
    return vs_treeitem::get_normal_attr();
  else if(state.NowBroken())
    return COLOR_PAIR(get_color("pkg_broken", COLOR_BLACK, COLOR_RED));
  else
    return A_BOLD|vs_treeitem::get_normal_attr();
}

void pkg_item::display(vs_tree *win, int y)
{
  vs_treeitem::display(win, y, package.Name());
}

bool pkg_item::dispatch_char(chtype ch)
{
  if(global_bindings.key_matches(ch, "PackageVersions"))
    {
      new pkg_ver_screen(package);
      return true;
    }
  else if(global_bindings.key_matches(ch, "PackageDependencies"))
    {
      pkgCache::VerIterator cand_ver=(*apt_cache_file)[package].CandidateVerIter(*apt_cache_file);

      if(!cand_ver.end())
	new pkg_dep_screen(cand_ver);
      return true;
    }
  else if(global_bindings.key_matches(ch, "PackageDescription"))
    {
      pkgCache::VerIterator cand_ver=(*apt_cache_file)[package].CandidateVerIter(*apt_cache_file);

      if(!cand_ver.end())
	new pkg_description_screen(cand_ver);
      return true;
    }
  else if(global_bindings.key_matches(ch, "PackageInfoScreen"))
    {
      new pkg_info_screen(package);
      return true;
    }
  else
    return pkg_tree_node::dispatch_char(ch);
}

bool pkg_item::matches(string s)
{
  return string(package.Name()).find(s)!=string::npos;
}
