/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The contents of this file are released under an Open Source 
 * Definition (OSD) compliant license; you may not use this file 
 * execpt in compliance with the license. Please see license.txt, 
 * distributed with this file. You may also obtain a copy of the
 * license at http://www.clc-marketing.com/xslp/license.txt
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 *
 * 
 */

package com.kvisco.xsl.util;

import java.io.PrintWriter;
import java.io.Writer;

/**
 * A simple implementation of MessageObserver
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class SimpleMessageObserver 
    implements MessageObserver
{
    
    
    PrintWriter myWriter = null;

    /**
     * Creates a new SimpleMessageObserver which will
     * print messages to the console
    **/
    public SimpleMessageObserver() {
        myWriter = new PrintWriter(System.out, true);
    } //-- SimpleMessageObserver

    /**
     * Creates a new SimpleMessageObserver which will
     * print messages to the given Writer
     * @param writer the Writer to print messages to
    **/
    public SimpleMessageObserver(Writer writer) {
        setWriter(writer);
    } //-- SimpleMessageObserver
    
    
    /**
     * Notifies this observer of a new message
     * @param message the message to observe
    **/
    public void recieveMessage(String message) {
        myWriter.print("xsl:message - ");
        myWriter.println(message);
        myWriter.flush();
    } //-- recieve
    
    
    /**
     * Sets the Writer of this MessageObserver
     * @param writer the Writer to print messages to
    **/
    public void setWriter(Writer writer) {
        myWriter = new PrintWriter(writer, true);
    } //--
    
} //-- MessageObserver