/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.*;
import org.w3c.dom.*;

/**
 * A class that represents the XSL text() function call
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class TextFunctionCall extends FunctionCall 
    implements NodeExpr
{
    
    /**
     * Creates a new TextFunctionCall
    **/
    public TextFunctionCall() {
        super(Names.TEXT_FN);
    } //-- TextFunctionCall
    
    /**
     * Evalutes this FunctionCall using the given Node as
     * the context. This method will always return a BooleanResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {        
        NodeSet nodeSet = new NodeSet();
        if (context == null) return nodeSet;
        String nodeName;
        NodeList nl = context.getChildNodes();
        for (int i = 0; i < nl.getLength(); i++) {
            Node node = nl.item(i);
            if (matches(node, context, ps)) nodeSet.add(node);
        }
        return nodeSet;
    } //-- evaluate
    
    public short getNodeExprType () { return NodeExpr.TEXT_EXPR; }
    
    /**
     * Determines if the given node is matched by this NodeExpr
     * within the given context
    **/
    public boolean matches(Node node, Node context, ProcessorState ps)
        throws InvalidExprException
    {
        if (node != null) {
            int nodeType = node.getNodeType();
            if ((nodeType == Node.TEXT_NODE) ||
                (nodeType == Node.CDATA_SECTION_NODE))
                return true;
        }
        return false;
    } //-- matches
    
} //-- TextFunctionCall