/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl;

/**
 * Represents a Number result 
**/
public class NumberResult implements ExprResult {

    private double value = Double.NaN;
    
      //----------------/
     //- Constructors -/
    //----------------/
    
    /**
     * Creates a new NumberResult with the default value
    **/
    public NumberResult() {
        super();        
    } //-- NumberResult
    
    /**
     * Creates a new NumberResult with the given value
    **/
    public NumberResult(double value) {
        this.value = value;
    } //-- NumberResult
    
      //------------------/
     //- Public Methods -/
    //------------------/
    
    /**
     * Returns the value of this ExprResult as a boolean
     * @return the value of this ExprResult as a boolean
    **/
    public boolean booleanValue() {
        return (this.value != 0.0);
    } //-- booleanValue
    
    /**
     * Returns true if the given ExprResult is of the same type
     * of this ExprResult, and their values are equal.
     * @return true if the given ExprResult is of the same type
     * of this ExprResult, and their values are equal. otherwise
     * false.
    **/
    public boolean equals(ExprResult exprResult) {
        if (exprResult == null) return false;
        if (exprResult.getResultType() != getResultType()) return false;
        return (value == exprResult.numberValue());
    } //-- equals
    
    /**
     * Returns the value of this ExprResult as a double
     * @return the value of this ExprResult as a double
    **/
    public double numberValue() {
        return value;
    } //-- number
    
    /**
     * Returns the type of this ExprResult
     * @return the type of this ExprResult
     * @see ExprResult
    **/
    public short getResultType() {
        return ExprResult.NUMBER;
    } //-- getResultType
    
    /**
     * Sets the value of this NumberResult
     * @param value the double value to use as the result value
    **/
    public void setValue(double value) {
        this.value = value;
    } //-- setValue
    
    /**
     * Returns the Java Object this ExprResult represents
     * @return the Java Object this ExprResult represents
    **/
    public Object toJavaObject() {
        return new Double(value);
    } //-- toJavaObject
    
    /**
     * Returns the value of this ExprResult as a String
     * @return the value of this ExprResult as a String
    **/
    public String toString() {
        int i = (int)value;
        if ( value == (double)i ) return String.valueOf(i);
        else return String.valueOf(value);
    } //--toString
    
} //-- NumberResult