/*
 * (C) Copyright Keith Visco 1998  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by 
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or 
 * lost profits even if the Copyright owner has been advised of the 
 * possibility of their occurrence.  
 */
 
package com.kvisco.xsl;

import java.util.Hashtable;
import java.io.PrintWriter;
import org.w3c.dom.*;

/**
 * An abstract class for processing Formatting Objects.
 * Extend this class if you wish to do anything meaningful with 
 * Formatting Objects.
 * @author Keith Visco
**/
public abstract class Formatter {
    
    
    private boolean indentResult = false;
    
    private int     indentSize   = 2; // default Size
    
      //----------------/
     //- Constructors -/
    //----------------/
    
    
    /**
     * Creates a new Formatter
    **/
    public Formatter() {
        super();
    } //-- Formatter
    

      //------------------/
     //- Public Methods -/
    //------------------/
       
    /**
     * Returns true if this Formatter is allowed to indent the result
     * @return true if this Formatter is allowed to indent the result
    **/
    public boolean getIndentResult() {
        return indentResult;
    } //-- getIndentResult
    
    /**
     * Returns the indent size for this Formatter
     * @return the indent size for this Formatter
    **/
    public int getIndentSize() { return indentSize; };
    
    /**
     * Sets whether or not this Formatter can indent the result
     * @param indentResult the boolean indicating whether or not
     * to allow indentation of the result 
    **/
    public void setIndentResult(boolean indentResult) {
        this.indentResult = indentResult;
    } //-- setIndentResult
    
    /**
     * Sets the size of the indentation 
     * @param size the number of spaces to indent, if indentation is allowed.
    **/
    public void setIndentSize(int size) {
        this.indentSize = size;
    } //-- setIndentSize
    
    /**
     * Processes the given set of nodes
     * @param document the Document to process
     * @param output the PrintStream for IO during processing.
     * @see org.w3c.dom.Document
    **/
    public abstract void process(Document document, PrintWriter output );


    /**
     * Processes the given set of nodes
     * @param document the Document to process
     * @param output the PrintStream for IO during processing.
     * @see org.w3c.dom.Document
     * I am providing a default implementation of this method to make it
     * backward compatible with already existing formatters. This method
     * should be implemented by subclasses to handle the OutputFormat
    **/
    public void process(Document document, PrintWriter output, OutputFormat format) {
        process(document, output);
    } //-- process
     
    /*
    public abstract void processStartElement
        (String name, NamedNodeMap);
    public abstract void processEndElement(String name);
    public abstract void processPI(String data);
    public abstract void processCDATASection(String data);
    public abstract void processEntityReference(String data);
    */
    
}