/*
 * (C) Copyright Keith Visco 1998  All rights reserved.
 *
 * The software is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by 
 * you as a result of using the software. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or 
 * lost profits even if the Copyright owner has been advised of the 
 * possibility of their occurrence.  
 */
package com.kvisco.xsl;

import org.w3c.dom.*;
import com.kvisco.xsl.functions.ErrorFunctionCall;

/**
 * Represents an XSLIf Object (xsl:if)
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class CopyOf extends XSLObject {
                
    private SelectExpr selectExpr = null;
    private ErrorFunctionCall efc = null;
    
    /**
     * Creates a new CopyOf object
    **/
    public CopyOf(XSLStylesheet parentStylesheet) {
        super(parentStylesheet,XSLObject.COPY_OF);
    } //-- CopyOf
        
    public NodeSet selectNodes(Node context, ProcessorState ps) 
        throws InvalidExprException 
    {
        if (efc != null) efc.evaluate(context, ps);
        if (selectExpr == null) return new NodeSet();
        return selectExpr.selectNodes(context, ps);
    } //-- evaluate
    
    /**
     * Sets the attribute with the given name to the given value.
     * @param name the name of the attribute to set
     * @param value the value to set the attribute to
     * @throws XSLException if this XSLObject does not allow attributes
     * with the given name, or if the attribute is read only
    **/
    public void setAttribute(String name, String value) 
        throws XSLException
    {
        if (Names.SELECT_ATTR.equals(name)) {
            try {
                selectExpr = ExpressionParser.createSelectExpr(value);
            }
            catch(InvalidExprException iee) {
                ErrorFunctionCall efc = new ErrorFunctionCall();
                efc.setError("#error: " + value + " is an invalid select expression.");
            }
        }
        super.setAttribute(name,  value);
    } //-- setAttribute
    
} //-- CopyOf