/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * Represents a comment() expression
 * @author Keith Visco (kvisco@ziplink.net)
**/
public class CommentExpr implements NodeExpr {

      //----------------/
     //- Constructors -/
    //----------------/

    public CommentExpr() {
        super();
    } //-- CommentExpr

      //------------------/
     //- Public Methods -/
    //------------------/


    /**
     * Returns the String representation of this NodeExpr
    **/
    public String toString() {
        StringBuffer sb = new StringBuffer(Names.COMMENT_FN);
        sb.append("()");
        return sb.toString();
    } //-- toString

    /**
     * Evaluates this Expr using the given context Node and ProcessorState
     * @param context the current context Node
     * @param ps the ProcessorState that contains the current processing
     * environment
     * @return the ExprResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps)
        throws InvalidExprException
    {
        NodeSet nodeSet = new NodeSet();
        if (context == null) return nodeSet;

        NodeList nl = context.getChildNodes();
        for (int i = 0; i < nl.getLength(); i++) {
            Node node = nl.item(i);
            if (node.getNodeType() == Node.COMMENT_NODE) nodeSet.add(node);
        }
        return nodeSet;
    } //-- evaluate

    public short getExprType() { return Expr.NODE_SET; }


    /**
     * Returns the type of this NodeExpr
     * @return the type of this NodeExpr
    **/
    public short getNodeExprType() { return NodeExpr.COMMENT_EXPR; }


    /**
     * Determines if the given node is matched by this NodeExpr
     * within the given context
    **/
    public boolean matches(Node node, Node context, ProcessorState ps)
        throws InvalidExprException
    {
        if (node == null) return false;
        return (node.getNodeType() == Node.COMMENT_NODE);
    } //-- matches

} //-- CommentExpr
