/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringExpr;
import com.kvisco.xsl.StringResult;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.functions.FunctionCall;
import org.w3c.dom.Node;

public class StringFunctionCall
extends FunctionCall {
    public StringFunctionCall() {
        super("string-length");
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        List list = this.getParameterList();
        int n = list.size();
        if (n > 1) {
            throw new InvalidExprException("invalid number of parameters for function: " + this);
        }
        if (n == 1) {
            Expr expr = (Expr)list.get(0);
            ExprResult exprResult = expr.evaluate(node, processorState);
            return StringExpr.toStringResult(exprResult);
        }
        return new StringResult(XSLObject.getNodeValue(node));
    }
}

