/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.net.URIUtils;
import com.kvisco.util.List;
import com.kvisco.xml.DOMReader;
import com.kvisco.xsl.BasicHTMLFormatter;
import com.kvisco.xsl.DefaultFormatter;
import com.kvisco.xsl.Formatter;
import com.kvisco.xsl.Output;
import com.kvisco.xsl.RuleProcessor;
import com.kvisco.xsl.XSLException;
import com.kvisco.xsl.XSLPIHandler;
import com.kvisco.xsl.XSLReader;
import com.kvisco.xsl.XSLStylesheet;
import com.kvisco.xsl.util.MessageObserver;
import com.kvisco.xsl.util.SimpleMessageObserver;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class XSLProcessor
implements MessageObserver {
    public static final String HELP_FLAG = "h";
    public static final String INPUT_FLAG = "i";
    public static final String FORMATTER_FLAG = "fo";
    public static final String OUTPUT_FLAG = "o";
    public static final String STYLESHEET_FLAG = "s";
    public static final String VALIDATE_FLAG = "val";
    public static final String VERSION_FLAG = "v";
    public static final String ERR_OUTPUT_FLAG = "e";
    private final String ERR_PROPERTIES_NOT_FOUND = "unable to load properties file";
    public static final String DOM_PACKAGE = "dom-package";
    public static final String INDENT_SIZE = "indent-size";
    private static final String FORMATTER_PREFIX = "formatter.";
    private final String HTML_RESULT_NS = "http://www.w3.org/TR/REC-html";
    private final String HTML = "html";
    private final String DEFAULT_NS = "";
    protected static final String PROPERTIES_FILE = "xslp.properties";
    private static final String appName = "XSL:P";
    private static final String appVersion = "1.0 Beta (19990822)";
    private String documentBase = null;
    private PrintWriter errorWriter = new PrintWriter(System.out, true);
    private Properties props = null;
    private DOMReader domReader = null;
    private String domPackageName = "DEFAULT";
    private List msgObservers = null;
    public static final MessageObserver DEFAULT_MESSAGE_OBSERVER = new SimpleMessageObserver();
    private boolean usingDefaults = false;
    private boolean validate = false;

    public XSLProcessor() {
        this.initialize();
    }

    public void addMessageObserver(MessageObserver messageObserver) {
        this.msgObservers.add(messageObserver);
    }

    public static String getAppInfo() {
        return "XSL:P 1.0 Beta (19990822)";
    }

    public String getDOMPackageName() {
        return this.domPackageName;
    }

    private static Hashtable getOptions(String[] stringArray, List list) {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (string != null) {
                    hashtable.put(string, stringArray[n]);
                    hashtable.put(new Integer(n), stringArray[n]);
                }
                if (!list.contains(string = stringArray[n].substring(1))) {
                    int n2 = 1;
                    while (n2 <= string.length()) {
                        if (list.contains(string.substring(0, n2))) {
                            if (n2 < string.length()) {
                                hashtable.put(string.substring(0, n2), string.substring(n2));
                                break;
                            }
                        } else if (n2 == string.length()) {
                            XSLProcessor.printError("invalid option: -" + string, true);
                        }
                        ++n2;
                    }
                }
            } else {
                if (string != null) {
                    hashtable.put(string, stringArray[n]);
                }
                hashtable.put(new Integer(n), stringArray[n]);
                string = null;
            }
            ++n;
        }
        if (string != null) {
            hashtable.put(string, "no value");
        }
        return hashtable;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    protected InputStream getResourceAsStream(String string) {
        return this.getClass().getResourceAsStream(string);
    }

    private void initialize() {
        this.msgObservers = new List();
        this.msgObservers.add(DEFAULT_MESSAGE_OBSERVER);
        this.props = new Properties();
        try {
            InputStream inputStream = null;
            File file = new File(PROPERTIES_FILE);
            inputStream = file.exists() ? new FileInputStream(file) : this.getResourceAsStream(PROPERTIES_FILE);
            if (inputStream != null) {
                this.props.load(inputStream);
            } else {
                this.usingDefaults = true;
            }
        }
        catch (IOException iOException) {
            this.usingDefaults = true;
        }
        this.initializeDOMReader();
    }

    private void initializeDOMReader() {
        this.domPackageName = this.props.getProperty(DOM_PACKAGE);
        if (this.domPackageName != null) {
            try {
                this.domReader = new DOMReader(this.props.getProperty(this.domPackageName));
            }
            catch (Exception exception) {
                this.errorWriter.print("unable to load DOM Package: ");
                this.errorWriter.print(this.domPackageName);
                this.errorWriter.println(" (" + this.props.getProperty(this.domPackageName) + ")");
                this.errorWriter.print(" -- ");
                this.errorWriter.println(exception.getMessage());
            }
        } else {
            this.domPackageName = "DEFAULT";
            try {
                this.domReader = new DOMReader();
            }
            catch (Exception exception) {
                this.errorWriter.print("unable to load DOM Package: DEFAULT");
                this.errorWriter.print(" (");
                this.errorWriter.print(DOMReader.getDefaultDOMPackageClassName());
                this.errorWriter.println(")");
                this.errorWriter.print(" -- ");
                this.errorWriter.println(exception.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) {
        block19: {
            Object object;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            FileWriter fileWriter = null;
            List list = new List(8);
            list.add(HELP_FLAG);
            list.add(STYLESHEET_FLAG);
            list.add(OUTPUT_FLAG);
            list.add(INPUT_FLAG);
            list.add(FORMATTER_FLAG);
            list.add(VALIDATE_FLAG);
            list.add(VERSION_FLAG);
            list.add(ERR_OUTPUT_FLAG);
            list.add("d");
            boolean bl = false;
            Hashtable hashtable = XSLProcessor.getOptions(stringArray, list);
            if (hashtable == null || hashtable.size() == 0) {
                XSLProcessor.printUsage(System.out);
                return;
            }
            if (hashtable.containsKey(HELP_FLAG)) {
                XSLProcessor.printHelp(System.out);
                return;
            }
            if (hashtable.containsKey(VERSION_FLAG)) {
                System.out.println("XSL:P 1.0 Beta (19990822)");
                return;
            }
            string3 = (String)hashtable.get(STYLESHEET_FLAG);
            string = (String)hashtable.get(INPUT_FLAG);
            string2 = (String)hashtable.get(OUTPUT_FLAG);
            string4 = (String)hashtable.get(FORMATTER_FLAG);
            bl = hashtable.containsKey("d");
            string5 = (String)hashtable.get(ERR_OUTPUT_FLAG);
            if (string5 != null) {
                try {
                    fileWriter = new FileWriter(string5);
                }
                catch (IOException iOException) {
                    XSLProcessor.printError("Cannot open error file: " + string5, false);
                }
            }
            if (string == null) {
                XSLProcessor.printError("XML filename missing.", true);
            }
            OutputStream outputStream = null;
            if (string2 == null) {
                outputStream = System.out;
            } else {
                try {
                    outputStream = new FileOutputStream(string2);
                }
                catch (IOException iOException) {
                    System.out.println("XSLProcessor error: " + iOException.getMessage());
                }
            }
            Formatter formatter = null;
            if (string4 != null) {
                try {
                    object = Class.forName(string4);
                    formatter = (Formatter)((Class)object).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.print("Unable to find the specified Formatter: ");
                    System.out.println(string4);
                    System.out.println("-- processing with default Formatter.");
                }
                catch (Exception exception) {
                    System.out.print("Unable to instantiate the specified Formatter: ");
                    System.out.println(string4);
                    System.out.println("-- processing with default Formatter.");
                }
            }
            object = new XSLProcessor();
            ((XSLProcessor)object).setValidation(hashtable.containsKey(VALIDATE_FLAG));
            if (fileWriter != null) {
                ((XSLProcessor)object).setErrorStream(fileWriter);
            }
            if (bl) {
                System.out.print("XSL:P invoked using ");
                System.out.println(((XSLProcessor)object).getDOMPackageName());
            }
            ((XSLProcessor)object).process(string, string3, new PrintWriter(outputStream), formatter);
            if (fileWriter == null) break block19;
            try {
                ((Writer)fileWriter).close();
            }
            catch (IOException iOException) {}
        }
    }

    private void parsePIs(Document document, XSLPIHandler xSLPIHandler) {
        if (document == null || xSLPIHandler == null) {
            return;
        }
        NodeList nodeList = document.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 7) {
                xSLPIHandler.handlePI((ProcessingInstruction)node);
            }
            ++n;
        }
    }

    private static void printError(String string, boolean bl) {
        System.out.println();
        System.out.println(XSLProcessor.getAppInfo());
        System.out.println("#error: " + string);
        XSLProcessor.printUsage(System.out, false);
        if (bl) {
            System.exit(0);
        }
    }

    private static void printHelp(PrintStream printStream) {
        printStream.println();
        printStream.println(XSLProcessor.getAppInfo());
        printStream.print("The following flags are available for use with ");
        printStream.println("XSL:P -");
        printStream.println();
        printStream.println("-i  filename  : The XML file to process");
        printStream.println("-o  filename  : The Output file to create");
        printStream.println("-s  filename  : The XSL file to use for processing  (Optional)");
        printStream.println("-fo classname : Formatter (for Formatting Objects)  (Optional)");
        printStream.println("-val          : Turns on xml validation if using    (Optional)");
        printStream.println("                a validating DOM parser");
        printStream.println("-h            : This help screen                    (Optional)");
        printStream.println();
    }

    private static void printUsage(PrintStream printStream) {
        XSLProcessor.printUsage(printStream, true);
    }

    private static void printUsage(PrintStream printStream, boolean bl) {
        printStream.println();
        if (bl) {
            printStream.println(XSLProcessor.getAppInfo());
        }
        printStream.println("usage:");
        printStream.print("java com.kvisco.xsl.XSLProcessor -");
        printStream.print("i xml-file [-");
        printStream.print("s xsl-file] [-");
        printStream.println("o output-file] [-val]");
        printStream.println();
        printStream.println("for more infomation use the -h flag");
    }

    public Document process(InputStream inputStream, InputStream inputStream2) {
        Document document = this.readXMLDocument(inputStream, null);
        XSLPIHandler xSLPIHandler = new XSLPIHandler();
        this.parsePIs(document, xSLPIHandler);
        XSLStylesheet xSLStylesheet = this.readXSLStylesheet(inputStream2, null, xSLPIHandler);
        return this.process(document, xSLStylesheet);
    }

    public void process(InputStream inputStream, InputStream inputStream2, PrintWriter printWriter) {
        this.process(inputStream, inputStream2, printWriter, null);
    }

    public void process(InputStream inputStream, InputStream inputStream2, PrintWriter printWriter, Formatter formatter) {
        Document document = this.readXMLDocument(inputStream, null);
        XSLPIHandler xSLPIHandler = new XSLPIHandler();
        this.parsePIs(document, xSLPIHandler);
        XSLStylesheet xSLStylesheet = this.readXSLStylesheet(inputStream2, null, xSLPIHandler);
        this.process(document, xSLStylesheet, printWriter, formatter);
    }

    public Document process(String string) {
        String string2 = null;
        return this.process(string, string2);
    }

    public void process(String string, PrintWriter printWriter) {
        this.process(string, null, printWriter);
    }

    public Document process(String string, String string2) {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            inputStream = URIUtils.getInputStream(string, this.documentBase);
        }
        catch (Exception exception) {
            this.errorWriter.println(exception.getMessage());
            this.errorWriter.println("processing aborted.");
            return null;
        }
        if (string2 != null && string2.length() > 0) {
            try {
                inputStream2 = URIUtils.getInputStream(string2, this.documentBase);
            }
            catch (Exception exception) {
                this.errorWriter.println("Error reading stylesheet");
                this.errorWriter.println(" -- " + exception.getMessage());
                this.errorWriter.println(" -- processing with default rules");
            }
        }
        XSLPIHandler xSLPIHandler = new XSLPIHandler();
        String string3 = URIUtils.resolveHref(string, this.documentBase);
        xSLPIHandler.setDocumentBase(URIUtils.getDocumentBase(string3));
        Document document = this.readXMLDocument(inputStream, string3);
        this.parsePIs(document, xSLPIHandler);
        XSLStylesheet xSLStylesheet = this.readXSLStylesheet(inputStream2, string2, xSLPIHandler);
        return this.process(document, xSLStylesheet);
    }

    public void process(String string, String string2, PrintWriter printWriter) {
        this.process(string, string2, printWriter, null);
    }

    public void process(String string, String string2, PrintWriter printWriter, Formatter formatter) {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        String string3 = URIUtils.resolveHref(string, this.documentBase);
        try {
            inputStream = URIUtils.getInputStream(string, this.documentBase);
        }
        catch (Exception exception) {
            this.errorWriter.println("unable to read XML Document " + string);
            this.errorWriter.println(" -- processing aborted.");
            return;
        }
        if (string2 != null && string2.length() > 0) {
            try {
                inputStream2 = URIUtils.getInputStream(string2, this.documentBase);
            }
            catch (Exception exception) {
                this.errorWriter.println("Error reading stylesheet");
                this.errorWriter.println(" -- " + exception.getMessage());
                this.errorWriter.println(" -- processing with default rules");
                this.errorWriter.flush();
            }
        }
        XSLPIHandler xSLPIHandler = new XSLPIHandler();
        xSLPIHandler.setDocumentBase(URIUtils.getDocumentBase(string3));
        Document document = this.readXMLDocument(inputStream, string3);
        this.parsePIs(document, xSLPIHandler);
        XSLStylesheet xSLStylesheet = this.readXSLStylesheet(inputStream2, string2, xSLPIHandler);
        this.process(document, xSLStylesheet, printWriter, formatter);
    }

    public Document process(Document document, XSLStylesheet xSLStylesheet) {
        RuleProcessor ruleProcessor = new RuleProcessor(xSLStylesheet, this.domReader.getDOMPackage());
        ruleProcessor.addMessageObserver(this);
        ruleProcessor.setErrorWriter(this.errorWriter);
        return ruleProcessor.process(document);
    }

    public void process(Document document, XSLStylesheet xSLStylesheet, PrintWriter printWriter) {
        this.process(document, xSLStylesheet, printWriter, null);
    }

    public void process(Document document, XSLStylesheet xSLStylesheet, PrintWriter printWriter, Formatter formatter) {
        String string;
        Document document2 = this.process(document, xSLStylesheet);
        if (document2 == null) {
            this.errorWriter.println("error: an empty document was generated.");
            this.errorWriter.flush();
            return;
        }
        Output output = xSLStylesheet.getOutput();
        String string2 = output.getMethod();
        if (string2 == null || string2.length() == 0) {
            string = document2.getDocumentElement().getNodeName();
            string2 = "html".equalsIgnoreCase(string) ? "html" : "xml";
        }
        if (formatter == null && (string = this.props.getProperty(FORMATTER_PREFIX + string2)) != null && string.length() > 0) {
            try {
                Class<?> clazz = Class.forName(string);
                formatter = (Formatter)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.errorWriter.print("Unable to find the specified Formatter: ");
                this.errorWriter.println(string);
                this.errorWriter.println("-- processing with default Formatter.");
            }
            catch (Exception exception) {
                this.errorWriter.print("Unable to instantiate the specified Formatter: ");
                this.errorWriter.println(string);
                this.errorWriter.println("-- processing with default Formatter.");
            }
        }
        if (formatter == null) {
            if (string2.equals("html") || string2.indexOf("http://www.w3.org/TR/REC-html") == 0) {
                formatter = new BasicHTMLFormatter();
                string = output.getAttribute("indent");
                formatter.setIndentResult("no".equals(string) ^ true);
            } else {
                formatter = new DefaultFormatter();
                formatter.setIndentResult(output.getIndent());
            }
        } else {
            formatter.setIndentResult(output.getIndent());
        }
        string = this.props.getProperty(INDENT_SIZE);
        if (string != null) {
            try {
                formatter.setIndentSize(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        formatter.process(document2, printWriter, output);
    }

    public Document process(Document document, Document document2) {
        XSLStylesheet xSLStylesheet = null;
        if (document2 == null) {
            XSLPIHandler xSLPIHandler = new XSLPIHandler();
            this.parsePIs(document, xSLPIHandler);
            xSLStylesheet = this.readXSLStylesheet(null, null, xSLPIHandler);
        } else {
            xSLStylesheet = this.readXSLStylesheet(document2, "XSL Document");
        }
        return this.process(document, xSLStylesheet);
    }

    public void process(Document document, Document document2, PrintWriter printWriter) {
        this.process(document, document2, printWriter, null);
    }

    public void process(Document document, Document document2, PrintWriter printWriter, Formatter formatter) {
        XSLStylesheet xSLStylesheet = null;
        if (document2 == null) {
            XSLPIHandler xSLPIHandler = new XSLPIHandler();
            this.parsePIs(document, xSLPIHandler);
            xSLStylesheet = this.readXSLStylesheet(null, null, xSLPIHandler);
        } else {
            xSLStylesheet = this.readXSLStylesheet(document2, "XSL Document");
        }
        this.process(document, xSLStylesheet, printWriter, formatter);
    }

    private Document readXMLDocument(InputStream inputStream, String string) {
        if (string == null) {
            string = this.documentBase != null ? String.valueOf(this.documentBase) + "XML Document" : "XML Document";
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        return this.domReader.readDocument(bufferedInputStream, string, this.validate, this.errorWriter);
    }

    private XSLStylesheet readXSLStylesheet(InputStream inputStream, String string, XSLPIHandler xSLPIHandler) {
        InputStream inputStream2 = inputStream;
        if (inputStream2 == null) {
            if (string == null && xSLPIHandler != null) {
                string = URIUtils.resolveHref(xSLPIHandler.getStylesheetHref(), xSLPIHandler.getDocumentBase());
            }
            if (string != null) {
                try {
                    inputStream2 = URIUtils.getInputStream(string, this.documentBase);
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    this.errorWriter.println(exceptionInInitializerError.getException());
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (Exception exception) {
                    this.errorWriter.println("Error reading stylesheet\n -- ");
                    this.errorWriter.println(exception);
                    this.errorWriter.println(" -- processing with default rules");
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                this.errorWriter.println("No stylesheet specified. Use `-s' option on");
                this.errorWriter.println("the command line, or `xml:stylesheet' PI");
                this.errorWriter.println("in XML document");
                this.errorWriter.println(" -- processing with default rules");
            }
        }
        XSLStylesheet xSLStylesheet = null;
        if (inputStream2 != null) {
            XSLReader xSLReader = new XSLReader(this.domReader);
            xSLReader.setErrorStream(this.errorWriter);
            try {
                xSLStylesheet = xSLReader.readStylesheet(inputStream2, string);
            }
            catch (XSLException xSLException) {
                this.errorWriter.println(xSLException.getMessage());
                xSLStylesheet = new XSLStylesheet();
            }
        } else {
            xSLStylesheet = new XSLStylesheet();
        }
        return xSLStylesheet;
    }

    private XSLStylesheet readXSLStylesheet(Document document, String string) {
        XSLStylesheet xSLStylesheet = null;
        if (document != null) {
            XSLReader xSLReader = new XSLReader(this.domReader);
            xSLReader.setErrorStream(this.errorWriter);
            try {
                xSLStylesheet = xSLReader.readStylesheet(document, string);
            }
            catch (XSLException xSLException) {
                this.errorWriter.println(xSLException.getMessage());
                this.errorWriter.println(" -- processing with default rules");
                xSLStylesheet = new XSLStylesheet();
            }
        } else {
            xSLStylesheet = new XSLStylesheet();
        }
        return xSLStylesheet;
    }

    public void recieveMessage(String string) {
        int n = 0;
        while (n < this.msgObservers.size()) {
            ((MessageObserver)this.msgObservers.get(n)).recieveMessage(string);
            ++n;
        }
    }

    public MessageObserver removeMessageObserver(MessageObserver messageObserver) {
        if (this.msgObservers.remove(messageObserver)) {
            return messageObserver;
        }
        return null;
    }

    public void setDOMReader(DOMReader dOMReader) {
        this.domReader = dOMReader;
        this.domPackageName = dOMReader.getDOMPackageClassName();
    }

    public void setDocumentBase(String string) {
        this.documentBase = string;
    }

    public void setErrorStream(PrintStream printStream) {
        this.errorWriter = new PrintWriter(printStream, true);
    }

    public void setErrorStream(Writer writer) {
        this.errorWriter = new PrintWriter(writer, true);
    }

    public void setProperty(String string, String string2) {
        ((Hashtable)this.props).put(string, string2);
        if (DOM_PACKAGE.equals(string)) {
            this.initializeDOMReader();
        }
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
    }
}

