/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;
import com.kvisco.xml.XMLUtil;
import com.kvisco.xsl.AttributeValueTemplate;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.SelectExpr;
import com.kvisco.xsl.XSLException;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.XSLSort;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Node;

class NodeSorter {
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_LANG = "en";

    NodeSorter() {
    }

    private static int compareAsNumbers(String string, String string2) {
        double d;
        double d2;
        try {
            d2 = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d2 = 0.0;
        }
        try {
            d = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        if (d2 < d) {
            return -1;
        }
        if (d2 == d) {
            return 0;
        }
        return 1;
    }

    private static String[] getSortedKeys(Hashtable hashtable, boolean bl, String string, String string2) {
        if (hashtable == null) {
            return new String[0];
        }
        String[] stringArray = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        if (string.intern() == "number") {
            return NodeSorter.sortAsNumbers(stringArray, bl, string2);
        }
        return NodeSorter.sortAsText(stringArray, bl, string2);
    }

    public static NodeSet sort(NodeSet nodeSet, XSLSort[] xSLSortArray, Node node, ProcessorState processorState) {
        NodeSet nodeSet2;
        if (xSLSortArray.length == 0) {
            return nodeSet;
        }
        Hashtable<String, NodeSet> hashtable = new Hashtable<String, NodeSet>(nodeSet.size());
        SelectExpr selectExpr = null;
        XSLSort xSLSort = xSLSortArray[0];
        String string = DEFAULT_LANG;
        String string2 = "ascending";
        String string3 = "text";
        try {
            AttributeValueTemplate attributeValueTemplate = xSLSort.getAttributeAsAVT("lang");
            if (attributeValueTemplate != null) {
                string = attributeValueTemplate.evaluate(node, processorState);
            }
            if ((attributeValueTemplate = xSLSort.getAttributeAsAVT("order")) != null) {
                string2 = attributeValueTemplate.evaluate(node, processorState);
            }
            if ((attributeValueTemplate = xSLSort.getAttributeAsAVT("data-type")) != null) {
                string3 = attributeValueTemplate.evaluate(node, processorState);
            }
        }
        catch (XSLException xSLException) {}
        boolean bl = string2.equals("ascending");
        NodeSet nodeSet3 = new NodeSet();
        int n = 0;
        while (n < nodeSet.size()) {
            Node node2 = nodeSet.get(n);
            try {
                selectExpr = xSLSort.getSelectExpr();
                NodeSet nodeSet4 = selectExpr.selectNodes(node2, processorState);
                String string4 = nodeSet4.size() > 0 ? XSLObject.getNodeValue(nodeSet4.get(0)) : EMPTY_STRING;
                if (string4.length() == 0) {
                    nodeSet3.add(node2);
                } else {
                    nodeSet2 = (NodeSet)hashtable.get(string4);
                    if (nodeSet2 == null) {
                        nodeSet2 = new NodeSet();
                        nodeSet2.add(node2);
                        hashtable.put(string4, nodeSet2);
                    } else {
                        nodeSet2.add(node2);
                    }
                }
            }
            catch (InvalidExprException invalidExprException) {
                System.out.println(invalidExprException.getMessage());
            }
            ++n;
        }
        XSLSort[] xSLSortArray2 = new XSLSort[xSLSortArray.length - 1];
        if (xSLSortArray.length > 1) {
            int n2 = 1;
            while (n2 < xSLSortArray.length) {
                xSLSortArray2[n2 - 1] = xSLSortArray[n2];
                ++n2;
            }
        }
        String[] stringArray = NodeSorter.getSortedKeys(hashtable, bl, string3, string);
        NodeSet nodeSet5 = new NodeSet(nodeSet.size());
        int n3 = 0;
        while (n3 < nodeSet3.size()) {
            nodeSet5.add(nodeSet3.get(n3));
            ++n3;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            nodeSet2 = (NodeSet)hashtable.get(stringArray[n4]);
            if (nodeSet2.size() > 1) {
                nodeSet2 = NodeSorter.sort(nodeSet2, xSLSortArray2, node, processorState);
            }
            int n5 = 0;
            while (n5 < nodeSet2.size()) {
                nodeSet5.add(nodeSet2.get(n5));
                ++n5;
            }
            ++n4;
        }
        return nodeSet5;
    }

    private static String[] sortAsNumbers(String[] stringArray, boolean bl, String string) {
        if (stringArray.length == 0) {
            return new String[0];
        }
        List list = new List(stringArray.length);
        list.add(stringArray[0]);
        int n = -1;
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            int n3 = 0;
            while (n3 < list.size()) {
                n = NodeSorter.compareAsNumbers(string2, (String)list.get(n3));
                if (bl) {
                    if (n < 0) {
                        list.add(n3, string2);
                        break;
                    }
                    if (n3 == list.size() - 1) {
                        list.add(string2);
                        break;
                    }
                } else {
                    if (n > 0) {
                        list.add(n3, string2);
                        break;
                    }
                    if (n3 == list.size() - 1) {
                        list.add(string2);
                        break;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return (String[])list.toArray(new String[list.size()]);
    }

    private static String[] sortAsText(String[] stringArray, boolean bl, String string) {
        Collator collator = Collator.getInstance(XMLUtil.getLocale(string));
        int n = -1;
        if (stringArray.length == 0) {
            return new String[0];
        }
        List list = new List(stringArray.length);
        list.add(stringArray[0]);
        int n2 = 1;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            int n3 = 0;
            while (n3 < list.size()) {
                n = collator.compare(string2, (String)list.get(n3));
                if (bl) {
                    if (n < 0) {
                        list.add(n3, string2);
                        break;
                    }
                    if (n3 == list.size() - 1) {
                        list.add(string2);
                        break;
                    }
                } else {
                    if (n > 0) {
                        list.add(n3, string2);
                        break;
                    }
                    if (n3 == list.size() - 1) {
                        list.add(string2);
                        break;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return (String[])list.toArray(new String[list.size()]);
    }
}

