/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.BooleanResult;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringExpr;
import java.util.Hashtable;
import org.w3c.dom.Node;

public class EqualityExpr
implements Expr {
    public static final short EQUAL = 0;
    public static final short LESS_THAN = 1;
    public static final short GREATER_THAN = 2;
    public static final short LT_OR_EQUAL = 4;
    public static final short GT_OR_EQUAL = 5;
    public static final short NOT_EQUAL = 6;
    private Expr leftExpr = null;
    private Expr rightExpr = null;
    private short compareOp = 0;
    private static Hashtable relationalOps = null;

    static {
        relationalOps = new Hashtable(5);
        relationalOps.put("=", new Short(0));
        relationalOps.put("<", new Short(1));
        relationalOps.put(">", new Short(2));
        relationalOps.put("<=", new Short(4));
        relationalOps.put(">=", new Short(5));
        relationalOps.put("!=", new Short(6));
    }

    public EqualityExpr(Expr expr, Expr expr2) {
        this.leftExpr = expr;
        this.rightExpr = expr2;
    }

    public EqualityExpr(Expr expr, Expr expr2, String string) throws InvalidExprException {
        Short s;
        this.compareOp = (short)-1;
        if (string != null && (s = (Short)relationalOps.get(string)) != null) {
            this.compareOp = s;
        }
        if (this.compareOp < 0 || this.compareOp > relationalOps.size()) {
            throw new InvalidExprException("invalid operator for relational expression");
        }
        this.leftExpr = expr;
        this.rightExpr = expr2;
    }

    public EqualityExpr(Expr expr, Expr expr2, short s) throws InvalidExprException {
        this.leftExpr = expr;
        this.rightExpr = expr2;
        if (s < 0 || s > relationalOps.size()) {
            throw new InvalidExprException("invalid operator for relational expression");
        }
        this.compareOp = s;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        if (this.leftExpr == null || this.rightExpr == null) {
            return BooleanResult.FALSE_RESULT;
        }
        ExprResult exprResult = null;
        ExprResult exprResult2 = null;
        exprResult2 = this.leftExpr.evaluate(node, processorState);
        exprResult = this.rightExpr.evaluate(node, processorState);
        short s = exprResult2.getResultType();
        short s2 = exprResult.getResultType();
        boolean bl = false;
        switch (this.compareOp) {
            case 0: {
                if (s != s2) {
                    if (s == 0 || s2 == 0) {
                        bl = exprResult.booleanValue() == exprResult2.booleanValue();
                        break;
                    }
                    if (s == 1 || s2 == 1) {
                        bl = exprResult.numberValue() == exprResult2.numberValue();
                        break;
                    }
                    exprResult = StringExpr.toStringResult(exprResult);
                    exprResult2 = StringExpr.toStringResult(exprResult2);
                    bl = exprResult2.equals(exprResult);
                    break;
                }
                if (s == 2) {
                    exprResult = StringExpr.toStringResult(exprResult);
                    exprResult2 = StringExpr.toStringResult(exprResult2);
                    bl = exprResult2.equals(exprResult);
                    break;
                }
                bl = exprResult2.equals(exprResult);
                break;
            }
            case 1: {
                bl = exprResult2.numberValue() < exprResult.numberValue();
                break;
            }
            case 2: {
                bl = exprResult2.numberValue() > exprResult.numberValue();
                break;
            }
            case 4: {
                bl = exprResult2.numberValue() >= exprResult.numberValue();
                break;
            }
            case 5: {
                bl = exprResult2.numberValue() >= exprResult.numberValue();
                break;
            }
            default: {
                bl = false;
            }
        }
        return new BooleanResult(bl);
    }

    public short getExprType() {
        return 1;
    }

    public static boolean isRelationalOperator(String string) {
        if (string == null) {
            return false;
        }
        return relationalOps.get(string) != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.leftExpr != null) {
            stringBuffer.append(this.leftExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(" ");
        switch (this.compareOp) {
            case 0: {
                stringBuffer.append("=");
                break;
            }
            case 1: {
                stringBuffer.append("<");
                break;
            }
            case 2: {
                stringBuffer.append(">");
                break;
            }
            case 4: {
                stringBuffer.append("<=");
                break;
            }
            case 5: {
                stringBuffer.append(">=");
                break;
            }
            case 6: {
                stringBuffer.append("!=");
                break;
            }
        }
        stringBuffer.append(" ");
        if (this.rightExpr != null) {
            stringBuffer.append(this.rightExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

