/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.ExprResult;

public class BooleanResult
implements ExprResult {
    public static final BooleanResult FALSE_RESULT = new BooleanResult(false);
    public static final BooleanResult TRUE_RESULT = new BooleanResult(true);
    private boolean value = false;

    public BooleanResult() {
    }

    public BooleanResult(ExprResult exprResult) {
        this.value = exprResult.booleanValue();
    }

    public BooleanResult(boolean bl) {
        this.value = bl;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public boolean equals(ExprResult exprResult) {
        if (exprResult.getResultType() != 0) {
            return false;
        }
        return this.value == exprResult.booleanValue();
    }

    public short getResultType() {
        return 0;
    }

    public boolean getValue() {
        return this.value;
    }

    public double numberValue() {
        if (this.value) {
            return 1.0;
        }
        return 0.0;
    }

    public void setValue(boolean bl) {
        this.value = bl;
    }

    public Object toJavaObject() {
        return new Boolean(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

